/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.TimeArgument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.server.command.EnumArgument;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.deleter.tasks.DeletionCircle;
import pregenerator.common.deleter.tasks.DeletionCircleExpansion;
import pregenerator.common.deleter.tasks.DeletionExcess;
import pregenerator.common.deleter.tasks.DeletionSquare;
import pregenerator.common.deleter.tasks.DeletionSquareExpansion;
import pregenerator.common.deleter.tasks.DeletionTimeOut;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;
import pregenerator.common.utils.misc.GenShape;

public class DeletionCommand {
    public static CommandBuilder createDeletionCommand() {
        CommandBuilder builder = new CommandBuilder("delete");
        Command radius = DeletionCommand::executeRadius;
        builder.addLiteral("radius");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
        builder.addArgument("Center", CenterArgument.center());
        builder.addArgument("Radius", RadiusArgument.integer(1, 25000), (Command<CommandSource>)radius);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)radius).popTop();
        Command expansion = DeletionCommand::executeExpansion;
        builder.addLiteral("expansion");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
        builder.addArgument("Center", CenterArgument.center());
        builder.addArgument("Min Radius", RadiusArgument.integer(0));
        builder.addArgument("Max Radius", RadiusArgument.integer(1), (Command<CommandSource>)expansion);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)expansion).popTop();
        Command trim = DeletionCommand::exececuteTrim;
        builder.addLiteral("trim");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        builder.addArgument("Center", CenterArgument.center());
        builder.addArgument("Min Radius", RadiusArgument.integer(1), (Command<CommandSource>)trim);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)trim).popTop();
        Command cleanup = DeletionCommand::executeCleanup;
        builder.addLiteral("timedtrim");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        builder.addArgument("Center", CenterArgument.center());
        builder.addArgument("Min Radius", RadiusArgument.integer(1));
        builder.addArgument("Min Time", (ArgumentType<?>)TimeArgument.func_218091_a(), (Command<CommandSource>)cleanup);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)cleanup).popTop();
        return builder;
    }

    private static int executeCleanup(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        BlockPos center = wrapper.get("Center", ILocationArgument.class).func_197280_c(wrapper.getSource());
        int radius = wrapper.get("Min Radius", Integer.class);
        int timeOut = wrapper.get("Min Time", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        ServerManager.INSTANCE.startTask(new DeletionTimeOut(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), new ChunkPos(center.func_177958_n(), center.func_177952_p()), radius, timeOut), wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int exececuteTrim(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        BlockPos center = wrapper.get("Center", ILocationArgument.class).func_197280_c(wrapper.getSource());
        int radius = wrapper.get("Min Radius", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        ServerManager.INSTANCE.startTask(new DeletionExcess(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), new ChunkPos(center.func_177958_n(), center.func_177952_p()), radius), wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeRadius(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.get("Shape", GenShape.class);
        BlockPos center = wrapper.get("Center", ILocationArgument.class).func_197280_c(wrapper.getSource());
        int radius = wrapper.get("Radius", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        BaseDeletionTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new DeletionSquare(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), new ChunkPos(center.func_177958_n(), center.func_177952_p()), radius);
                break;
            }
            case CIRCLE: {
                task = new DeletionCircle(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), new ChunkPos(center.func_177958_n(), center.func_177952_p()), radius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeExpansion(CommandContext<CommandSource> source) {
        int maxRadius;
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.get("Shape", GenShape.class);
        BlockPos center = wrapper.get("Center", ILocationArgument.class).func_197280_c(wrapper.getSource());
        int minRadius = wrapper.get("Min Radius", Integer.class);
        if (minRadius > (maxRadius = wrapper.get("Max Radius", Integer.class).intValue())) {
            wrapper.sendErrorMessage("Min Radius is not allowed to be bigger then Max Radius");
            return 0;
        }
        if (maxRadius * maxRadius - minRadius * minRadius > 1000000000) {
            wrapper.sendErrorMessage("Expansions bigger then 1Billion Chunks are not allowed");
            return 0;
        }
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        BaseDeletionTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new DeletionSquareExpansion(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), new ChunkPos(center.func_177958_n(), center.func_177952_p()), minRadius, maxRadius);
                break;
            }
            case CIRCLE: {
                task = new DeletionCircleExpansion(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), new ChunkPos(center.func_177958_n(), center.func_177952_p()), minRadius, maxRadius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }
}

