/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.server.command.EnumArgument;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.commands.arguments.SuggestableEnumArgument;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.CircleExpansionTask;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.SquareExpansionTask;
import pregenerator.common.generator.tasks.SquareTask;
import pregenerator.common.generator.tasks.WorldBorderTask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;
import pregenerator.common.utils.misc.GenShape;

public class GenCommand {
    public static CommandBuilder createGenStart() {
        CommandBuilder builder = new CommandBuilder("gen");
        Command radius = GenCommand::executeRadius;
        builder.addLiteral("radius");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
        builder.addArgument("Center", CenterArgument.center());
        builder.addArgument("Radius", RadiusArgument.integer(1, 25000), (Command<CommandSource>)radius);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)radius);
        builder.addArgument("Generation Type", SuggestableEnumArgument.enumArgument(GenerationType.class), (Command<CommandSource>)radius).popTop();
        Command expansion = GenCommand::executeExpansion;
        builder.addLiteral("expansion");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
        builder.addArgument("Center", CenterArgument.center());
        builder.addArgument("Min Radius", RadiusArgument.integer(1));
        builder.addArgument("Max Radius", RadiusArgument.integer(1), (Command<CommandSource>)expansion);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)expansion);
        builder.addArgument("Generation Type", SuggestableEnumArgument.enumArgument(GenerationType.class), (Command<CommandSource>)expansion).popTop();
        Command border = GenCommand::executeWorldBorder;
        builder.addLiteral("worldborder");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word(), (Command<CommandSource>)border);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)border);
        builder.addArgument("Generation Type", SuggestableEnumArgument.enumArgument(GenerationType.class), (Command<CommandSource>)border).popTop();
        return builder;
    }

    private static int executeWorldBorder(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        GenerationType gen = wrapper.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension);
        WorldBorder border = ServerLifecycleHooks.getCurrentServer().func_71218_a(dim).func_175723_af();
        int size = (int)(border.func_177741_h() / 2.0);
        if (size * size > 1000000000) {
            wrapper.sendErrorMessage("WorldBorder generation bigger then 1Billion Chunks are not allowed, WHY THE FUCK DO YOU WANT THIS!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(new WorldBorderTask(name, (RegistryKey<World>)dim, gen.getIndex()), wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeRadius(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.get("Shape", GenShape.class);
        BlockPos center = wrapper.get("Center", ILocationArgument.class).func_197280_c(wrapper.getSource());
        int radius = wrapper.get("Radius", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        GenerationType gen = wrapper.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        BaseTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new SquareTask(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.func_177958_n(), center.func_177952_p()), radius);
                break;
            }
            case CIRCLE: {
                task = new CircleTask(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.func_177958_n(), center.func_177952_p()), radius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeExpansion(CommandContext<CommandSource> source) {
        int maxRadius;
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.get("Shape", GenShape.class);
        BlockPos center = wrapper.get("Center", ILocationArgument.class).func_197280_c(wrapper.getSource());
        int minRadius = wrapper.get("Min Radius", Integer.class);
        if (minRadius > (maxRadius = wrapper.get("Max Radius", Integer.class).intValue())) {
            wrapper.sendErrorMessage("Min Radius is not allowed to be bigger then Max Radius");
            return 0;
        }
        if (maxRadius * maxRadius - minRadius * minRadius > 1000000000) {
            wrapper.sendErrorMessage("Expansions bigger then 1Billion Chunks are not allowed, WHY THE FUCK DO YOU WANT THIS!");
            return 0;
        }
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().func_197023_e().func_234923_W_().func_240901_a_());
        GenerationType gen = wrapper.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        BaseTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new SquareExpansionTask(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.func_177958_n(), center.func_177952_p()), minRadius, maxRadius);
                break;
            }
            case CIRCLE: {
                task = new CircleExpansionTask(name, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.func_177958_n(), center.func_177952_p()), minRadius, maxRadius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }
}

