/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;

public class InfoCommand {
    public static CommandBuilder createInfoCommand() {
        CommandBuilder builder = new CommandBuilder("info");
        builder.addLiteral("listen", (Command<CommandSource>)((Command)InfoCommand::listen)).popTop();
        builder.addLiteral("unlisten", (Command<CommandSource>)((Command)InfoCommand::unlisten)).popTop();
        builder.addLiteral("autolisten", (Command<CommandSource>)((Command)InfoCommand::autoListenState)).addLiteral("enable", (Command<CommandSource>)((Command)InfoCommand::enableAuto)).pop();
        builder.addLiteral("disable", (Command<CommandSource>)((Command)InfoCommand::disableAuto)).pop();
        builder.addLiteral("reset", (Command<CommandSource>)((Command)InfoCommand::resetAuto)).popTop();
        return builder;
    }

    static UUID getSender(CommandContext<CommandSource> source) {
        Entity entity = ((CommandSource)source.getSource()).func_197022_f();
        return entity instanceof PlayerEntity ? entity.func_110124_au() : null;
    }

    public static int listen(CommandContext<CommandSource> source) {
        ServerManager.INSTANCE.addListener(InfoCommand.getSender(source));
        return 0;
    }

    public static int unlisten(CommandContext<CommandSource> source) {
        ServerManager.INSTANCE.removeListener(InfoCommand.getSender(source));
        return 0;
    }

    public static int enableAuto(CommandContext<CommandSource> source) {
        if (TaskStorage.getListeners().add(InfoCommand.getSender(source), true)) {
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " started Listening to Tasks"), true);
        } else {
            ((CommandSource)source.getSource()).func_197021_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " already Listening to Tasks"));
        }
        return 0;
    }

    public static int disableAuto(CommandContext<CommandSource> source) {
        if (TaskStorage.getListeners().add(InfoCommand.getSender(source), false)) {
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " started Ignoring Tasks"), true);
        } else {
            ((CommandSource)source.getSource()).func_197021_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " already Ignoring Tasks"));
        }
        return 0;
    }

    public static int resetAuto(CommandContext<CommandSource> source) {
        TaskStorage.getListeners().remove(InfoCommand.getSender(source));
        ((CommandSource)source.getSource()).func_197021_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " Reseted Task Listening"));
        return 0;
    }

    public static int autoListenState(CommandContext<CommandSource> source) {
        switch (TaskStorage.getListeners().getState(InfoCommand.getSender(source))) {
            case 0: {
                ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " is not Listening to Tasks"), true);
                break;
            }
            case 1: {
                ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " is Ignoring Tasks"), true);
                break;
            }
            case 2: {
                ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(((CommandSource)source.getSource()).func_197037_c() + " is Listening to Tasks"), true);
            }
        }
        return 0;
    }
}

