/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.commands.BenchmarkCommand;
import pregenerator.common.commands.DeletionCommand;
import pregenerator.common.commands.GenCommand;
import pregenerator.common.commands.InfoCommand;
import pregenerator.common.commands.RetrogenCommand;
import pregenerator.common.commands.arguments.UnloadedDimensionArgument;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.DimensionManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class PregenCommand {
    public static void registerCommand(CommandDispatcher<CommandSource> dispatcher) {
        CommandBuilder source = new CommandBuilder(LiteralArgumentBuilder.literal((String)"pregen").requires(T -> T.func_197034_c(3)));
        CommandBuilder builder = new CommandBuilder("start");
        builder.merge(GenCommand.createGenStart()).popTop();
        builder.merge(DeletionCommand.createDeletionCommand()).popTop();
        builder.merge(BenchmarkCommand.createBenchmark()).popTop();
        source.merge(builder).popTop();
        source.merge(RetrogenCommand.createRetogenCommand()).popTop();
        source.merge(InfoCommand.createInfoCommand()).popTop();
        PregenCommand.createControlTasks(source).popTop();
        source.merge(PregenCommand.createSimpleTasks(new CommandBuilder("utils"))).popTop();
        dispatcher.getRoot().addChild(source.build());
    }

    static CommandBuilder createControlTasks(CommandBuilder source) {
        source.addLiteral("taskList").addLiteral("gen", (Command<CommandSource>)((Command)PregenCommand::listGenTasks)).pop();
        source.addLiteral("deletion", (Command<CommandSource>)((Command)PregenCommand::listDeletionTasks)).popTop();
        Command cmd = T -> ServerManager.INSTANCE.pauseTask(new CommandWrapper((CommandContext<CommandSource>)T).getOrDefault("Task Name", String.class, null), V -> ((CommandSource)T.getSource()).func_197030_a(V, false));
        source.addLiteral("pause", (Command<CommandSource>)cmd).addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word(), (Command<CommandSource>)cmd).popTop();
        cmd = T -> ServerManager.INSTANCE.resumeTask(new CommandWrapper((CommandContext<CommandSource>)T).getOrDefault("Task Name", String.class, null), V -> ((CommandSource)T.getSource()).func_197030_a(V, false));
        source.addLiteral("resume", (Command<CommandSource>)cmd).addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word(), (Command<CommandSource>)cmd).popTop();
        source.addLiteral("continue", (Command<CommandSource>)((Command)PregenCommand::continueAny));
        source.addArgument((ArgumentBuilder<CommandSource, ?>)((RequiredArgumentBuilder)Commands.func_197056_a((String)"Task Name", (ArgumentType)StringArgumentType.word()).executes(PregenCommand::continueTask)).suggests((T, V) -> ISuggestionProvider.func_197005_b(TaskStorage.getTasks(), (SuggestionsBuilder)V))).popTop();
        source.addLiteral("stop", (Command<CommandSource>)((Command)PregenCommand::stopAll));
        source.addArgument((ArgumentBuilder<CommandSource, ?>)((RequiredArgumentBuilder)Commands.func_197056_a((String)"Task Name", (ArgumentType)StringArgumentType.word()).executes(PregenCommand::stopTask)).suggests((T, V) -> ISuggestionProvider.func_197005_b(TaskStorage.getActiveTasks(), (SuggestionsBuilder)V)));
        source.addArgument("Delete Task", (ArgumentType<?>)BoolArgumentType.bool(), (Command<CommandSource>)((Command)PregenCommand::stopTask)).popTop();
        source.addLiteral("clear", (Command<CommandSource>)((Command)PregenCommand::clearTask));
        source.addArgument((ArgumentBuilder<CommandSource, ?>)((RequiredArgumentBuilder)Commands.func_197056_a((String)"Task Name", (ArgumentType)StringArgumentType.word()).executes(PregenCommand::clearTask)).suggests((T, V) -> ISuggestionProvider.func_197005_b(TaskStorage.getTasks(), (SuggestionsBuilder)V))).popTop();
        return source;
    }

    static CommandBuilder createSimpleTasks(CommandBuilder source) {
        source.addLiteral("profiler").addLiteral("enable", (Command<CommandSource>)((Command)PregenCommand::enableTracker)).pop().addLiteral("disable", (Command<CommandSource>)((Command)PregenCommand::disableTracker)).popTop();
        source.addLiteral("gc", (Command<CommandSource>)((Command)PregenCommand::gc)).popTop();
        source.addLiteral("dimensions").addLiteral("info", (Command<CommandSource>)((Command)PregenCommand::infoDimensions)).pop();
        source.addLiteral("disable").addArgument("dim", (ArgumentType<?>)DimensionArgument.func_212595_a(), (Command<CommandSource>)((Command)PregenCommand::disableDimension)).pop(2);
        source.addLiteral("enable").addArgument("dim", (ArgumentType<?>)UnloadedDimensionArgument.getUnloadedDimension(), (Command<CommandSource>)((Command)PregenCommand::enableDimension)).popTop();
        return source;
    }

    private static int disableDimension(CommandContext<CommandSource> source) {
        DimensionManager.INSTANCE.disableDimension((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)source.getArgument("dim", ResourceLocation.class))), T -> ((CommandSource)source.getSource()).func_197030_a(T, true));
        return 0;
    }

    private static int enableDimension(CommandContext<CommandSource> source) {
        DimensionManager.INSTANCE.enableDimension((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)source.getArgument("dim", ResourceLocation.class))), T -> ((CommandSource)source.getSource()).func_197030_a(T, true));
        return 0;
    }

    private static int infoDimensions(CommandContext<CommandSource> source) {
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("The Dimension Command allows you to \"Disable\" Dimensions."), true);
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Disabling a Dimension will make it inaccessible for the game and it will be treated like as if the Dimension never existed in the first place"), true);
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("On top of that Disabled Dimensions will load on Startup and will be automatically shutdown. This will increase restart time for a tiny bit."), true);
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Once ChunkPregen is deinstalled all Dimensions will load like normal but the \"Disabling Information\" is stored in the world itself so removing/adding the mod will not change anything"), true);
        return 0;
    }

    private static int gc(CommandContext<CommandSource> source) {
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Starting Memory Cleanup. Might Freeze Server"), true);
        System.gc();
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Finished Memory Cleanup"), true);
        return 0;
    }

    private static int enableTracker(CommandContext<CommandSource> source) {
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(ServerTracker.INSTANCE.toggle(true) ? "Enabled Tracker" : "Tracker is already Enabled"), true);
        return 0;
    }

    private static int disableTracker(CommandContext<CommandSource> source) {
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(ServerTracker.INSTANCE.toggle(false) ? "Disabled Tracker" : "Tracker is already Disabled"), true);
        return 0;
    }

    private static int continueTask(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        return ServerManager.INSTANCE.continueTask(wrapper.getOrDefault("Task Name", String.class, null), wrapper.getSenderId(), wrapper);
    }

    private static int continueAny(CommandContext<CommandSource> source) {
        ServerManager.INSTANCE.continueTask(T -> ((CommandSource)source.getSource()).func_197030_a(T, true));
        return 0;
    }

    private static int clearTask(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        return ServerManager.INSTANCE.removeTask(wrapper.getOrDefault("Task Name", String.class, null), wrapper);
    }

    private static int stopTask(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        if (wrapper.getOrDefault("Delete Task", Boolean.class, false).booleanValue()) {
            return ServerManager.INSTANCE.removeTask(wrapper.get("Task Name", String.class), wrapper);
        }
        return ServerManager.INSTANCE.stopTask(wrapper.get("Task Name", String.class), wrapper, false);
    }

    private static int stopAll(CommandContext<CommandSource> source) {
        return ServerManager.INSTANCE.stopTask(null, T -> ((CommandSource)source.getSource()).func_197030_a(T, true), false);
    }

    private static int listGenTasks(CommandContext<CommandSource> source) {
        GenTaskStorage storage = TaskStorage.getGenStorage();
        boolean empty = true;
        for (String s : storage.getTasks()) {
            empty = false;
            ITask task = (ITask)storage.getTask(s);
            IFormattableTextComponent desc = task.getTaskDescription();
            if (storage.isTaskActive(s)) {
                desc.func_240702_b_("[Active]");
            }
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)desc, false);
        }
        if (empty) {
            ((CommandSource)source.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Task List Empty"));
        }
        return 0;
    }

    private static int listDeletionTasks(CommandContext<CommandSource> source) {
        SimpleTaskStorage<IDeletionTask> storage = TaskStorage.getDeletionStorage();
        boolean empty = true;
        for (String s : storage.getTasks()) {
            empty = false;
            IDeletionTask task = storage.getTask(s);
            IFormattableTextComponent desc = task.getTaskDescription();
            if (storage.isTaskActive(s)) {
                desc.func_240702_b_("[Active]");
            }
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)desc, false);
        }
        if (empty) {
            ((CommandSource)source.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Task List Empty"));
        }
        return 0;
    }
}

