/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public abstract class BaseDeletionTask
implements IDeletionTask {
    String name;
    RegistryKey<World> type;

    public BaseDeletionTask(CompoundNBT nbt) {
        this(nbt.func_74779_i("name"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))));
    }

    public BaseDeletionTask(String name, RegistryKey<World> type) {
        this.name = name;
        this.type = type;
    }

    public abstract void append(IFormattableTextComponent var1);

    public abstract ChunkDeleter createTask(ServerWorld var1, IProcess.PrepaireProgress var2);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RegistryKey<World> getDimension() {
        return this.type;
    }

    @Override
    public IFormattableTextComponent getTaskDescription() {
        StringTextComponent text = new StringTextComponent("[");
        ITask.convert("Name=" + this.getName() + ",", (IFormattableTextComponent)text, TextFormatting.AQUA);
        ITask.convert("Dim=" + this.getDimension().getRegistryName().func_110623_a() + ", ", (IFormattableTextComponent)text, TextFormatting.GREEN);
        this.append((IFormattableTextComponent)text);
        return text.func_240702_b_("]");
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("dim", this.type.func_240901_a_().toString());
        return nbt;
    }

    @Override
    public CompletableFuture<ChunkDeleter> createTask(ServerWorld world, Executor exe, IProcess.PrepaireProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    protected File getSaveFile() {
        return ServerLifecycleHooks.getCurrentServer().func_240776_a_(FolderName.field_237253_i_).getParent().toFile();
    }

    protected boolean isRegionFile(File file, String fileName) {
        return fileName.endsWith(".mca");
    }

    protected File[] getRegionFiles() {
        File[] array = new File(DimensionType.func_236031_a_(this.getDimension(), (File)this.getSaveFile()), "region").listFiles(this::isRegionFile);
        return array == null ? new File[]{} : array;
    }
}

