/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.util.BitSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionExcess
extends BaseDeletionTask {
    ChunkPos center;
    int radius;
    long cachedSize = -1L;

    public DeletionExcess(CompoundNBT nbt) {
        super(nbt);
        this.center = new ChunkPos(nbt.func_74763_f("center"));
        this.radius = nbt.func_74762_e("radius");
        this.cachedSize = nbt.func_74764_b("cache") ? nbt.func_74763_f("cache") : -1L;
    }

    public DeletionExcess(String name, RegistryKey<World> type, ChunkPos center, int radius) {
        super(name, type);
        this.center = center;
        this.radius = radius;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = super.write();
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74772_a("center", this.center.func_201841_a());
        if (this.cachedSize != -1L) {
            nbt.func_74772_a("cache", this.cachedSize);
        }
        return nbt;
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public String getShapeName() {
        return "Excess";
    }

    @Override
    public long getTaskSize() {
        return this.cachedSize == -1L ? (this.cachedSize = this.calculateCacheSize()) : this.cachedSize;
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ITask.convert("Type=Trim, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=" + this.center.field_77276_a + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=" + this.center.field_77275_b + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.radius, builder, TextFormatting.BLUE);
    }

    @Override
    public ChunkDeleter createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        Long2ObjectOpenHashMap toDelete = new Long2ObjectOpenHashMap();
        long total = 0L;
        progress.setMax((long)this.getRegionFiles().length * 1024L);
        for (File subFile : this.getRegionFiles()) {
            if (!progress.isAlive()) break;
            String[] name = subFile.getName().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.field_77276_a;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.field_77275_b;
            if (minX < -this.radius || minX + 32 > this.radius || minZ < -this.radius || minZ + 32 > this.radius) {
                try (RegionFile file = new RegionFile(subFile, subFile.getParentFile(), false);){
                    BitSet set = new BitSet(1024);
                    for (int i = 0; i < 1024; ++i) {
                        int x = i % 32 + minX;
                        int z = i / 32 + minZ;
                        if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.func_222667_d(new ChunkPos(i % 32, i / 32))) continue;
                        set.set(i);
                        ++total;
                    }
                    if (!set.isEmpty()) {
                        toDelete.put(ChunkPos.func_77272_a((int)(minX >> 5), (int)(minZ >> 5)), (Object)set);
                    }
                    progress.growValue(1024);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            progress.growValue(1024);
        }
        this.cachedSize = total;
        return new ChunkDeleter((RegistryKey<World>)this.type, this.getSaveFile(), world).init((Long2ObjectMap<BitSet>)toDelete, this.center, progress);
    }

    private long calculateCacheSize() {
        long total = 0L;
        for (File subFile : this.getRegionFiles()) {
            String[] name = subFile.getName().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.field_77276_a;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.field_77275_b;
            if (minX >= -this.radius && minX + 32 <= this.radius && minZ >= -this.radius && minZ + 32 <= this.radius) continue;
            try (RegionFile file = new RegionFile(subFile, subFile.getParentFile(), false);){
                for (int i = 0; i < 1024; ++i) {
                    int x = i % 32 + minX;
                    int z = i / 32 + minZ;
                    if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.func_222667_d(new ChunkPos(i % 32, i / 32))) continue;
                    ++total;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return total;
    }
}

