/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionSquare
extends BaseDeletionTask {
    long center;
    int radius;

    public DeletionSquare(CompoundNBT nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.radius = nbt.func_74762_e("radius");
    }

    public DeletionSquare(String name, RegistryKey<World> type, ChunkPos center, int radius) {
        super(name, type);
        this.center = center.func_201841_a();
        this.radius = radius;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public String getShapeName() {
        return "Square";
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Square, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.field_77276_a + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=" + center.field_77275_b + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Radius=" + this.radius, builder, TextFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        long diameter = (long)this.radius * 2L;
        return diameter * diameter;
    }

    @Override
    public ChunkDeleter createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((RegistryKey<World>)this.type, this.getSaveFile(), world);
        ChunkPos center = new ChunkPos(this.center);
        return deleter.init(ChunkShapeBuilder.getSquareShape(center.field_77276_a, center.field_77275_b, this.radius, progress), center, progress);
    }
}

