/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.util.BitSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionTimeOut
extends BaseDeletionTask {
    ChunkPos center;
    int radius;
    long timeOut;
    long cachedSize = -1L;

    public DeletionTimeOut(CompoundNBT nbt) {
        super(nbt);
        this.center = new ChunkPos(nbt.func_74763_f("center"));
        this.radius = nbt.func_74762_e("radius");
        this.timeOut = nbt.func_74763_f("time");
        this.cachedSize = nbt.func_74764_b("cache") ? nbt.func_74763_f("cache") : -1L;
    }

    public DeletionTimeOut(String name, RegistryKey<World> type, ChunkPos center, int radius, long timeOut) {
        super(name, type);
        this.center = center;
        this.radius = radius;
        this.timeOut = timeOut;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = super.write();
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74772_a("time", this.timeOut);
        nbt.func_74772_a("center", this.center.func_201841_a());
        if (this.cachedSize != -1L) {
            nbt.func_74772_a("cache", this.cachedSize);
        }
        return nbt;
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String getShapeName() {
        return "TimeOut";
    }

    @Override
    public long getTaskSize() {
        return this.cachedSize == -1L ? (this.cachedSize = this.calculateCacheSize()) : this.cachedSize;
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ITask.convert("Type=Cleanup, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("Timout=" + this.timeOut + ", ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=" + this.center.field_77276_a + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=" + this.center.field_77275_b + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.radius, builder, TextFormatting.BLUE);
    }

    @Override
    public ChunkDeleter createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        ObjectArrayList list = new ObjectArrayList();
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        progress.setMax((long)this.getRegionFiles().length * 1024L);
        for (File subFile : this.getRegionFiles()) {
            String[] name = subFile.getName().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.field_77276_a;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.field_77275_b;
            if (minX < -this.radius || minX + 32 > this.radius || minZ < -this.radius || minZ + 32 > this.radius) {
                list.add(service.submit(() -> {
                    if (!progress.isAlive()) {
                        return new ScanResult(ChunkPos.func_77272_a((int)(minX >> 5), (int)(minZ >> 5)), new BitSet());
                    }
                    long result = ChunkPos.func_77272_a((int)(minX >> 5), (int)(minZ >> 5));
                    BitSet set = new BitSet(1024);
                    try (RegionFile region = new RegionFile(subFile, subFile.getParentFile(), false);){
                        for (int i = 0; i < 1024 && progress.isAlive(); ++i) {
                            int x = i % 32 + minX;
                            int z = i / 32 + minZ;
                            ChunkPos pos = new ChunkPos(i % 32, i / 32);
                            if ((x > this.radius || x < -this.radius || z > this.radius || z < -this.radius) && region.func_222667_d(pos) && this.canBeDeleted(region, pos)) {
                                set.set(i);
                            }
                            progress.growValue(1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return new ScanResult(result, set);
                }));
                continue;
            }
            progress.growValue(1024);
        }
        service.shutdown();
        Long2ObjectOpenHashMap toDelete = new Long2ObjectOpenHashMap();
        long total = 0L;
        while (progress.isAlive() && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((Future)list.get(i)).isDone()) continue;
                try {
                    ((ScanResult)((Future)list.remove(i--)).get()).apply((Long2ObjectMap<BitSet>)toDelete);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        if (!progress.isAlive() && list.size() > 0) {
            for (Future entry : list) {
                entry.cancel(true);
            }
            service.shutdownNow();
        }
        this.cachedSize = total;
        return new ChunkDeleter((RegistryKey<World>)this.type, this.getSaveFile(), world).init((Long2ObjectMap<BitSet>)toDelete, this.center, progress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canBeDeleted(RegionFile file, ChunkPos pos) {
        try (DataInputStream stream = file.func_222666_a(pos);){
            if (stream == null) return false;
            CompoundNBT nbt = CompressedStreamTools.func_74794_a((DataInput)stream);
            boolean bl = nbt != null && (ChunkSerializer.func_222651_a((CompoundNBT)nbt) == ChunkStatus.Type.PROTOCHUNK || nbt.func_74775_l("Level").func_74763_f("InhabitedTime") <= this.timeOut);
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long calculateCacheSize() {
        long total = 0L;
        for (File subFile : this.getRegionFiles()) {
            String[] name = subFile.getName().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.field_77276_a;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.field_77275_b;
            if (minX >= -this.radius && minX + 32 <= this.radius && minZ >= -this.radius && minZ + 32 <= this.radius) continue;
            try (RegionFile file = new RegionFile(subFile, subFile.getParentFile(), false);){
                for (int i = 0; i < 1024; ++i) {
                    int x = i % 32 + minX;
                    int z = i / 32 + minZ;
                    if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.func_222667_d(new ChunkPos(i % 32, i / 32))) continue;
                    ++total;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return total;
    }

    static class ScanResult {
        long pos;
        BitSet set;

        public ScanResult(long pos, BitSet set) {
            this.pos = pos;
            this.set = set;
        }

        public long apply(Long2ObjectMap<BitSet> map) {
            if (!this.set.isEmpty()) {
                map.put(this.pos, (Object)this.set);
                return this.set.cardinality();
            }
            return 0L;
        }
    }
}

