/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.manager.IProcess;

public enum ChunkLogger {
    Task{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            text.func_230529_a_((ITextComponent)1.wrap(new StringTextComponent("Task Name: " + processor.getTaskName()).func_240699_a_(TextFormatting.RED)));
        }
    }
    ,
    World{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            text.func_230529_a_((ITextComponent)2.wrap(new StringTextComponent("World: " + 2.toPascalCase(processor.getTask().getDimension().func_240901_a_().func_110623_a())).func_240699_a_(TextFormatting.GREEN))).func_240702_b_(" ");
            text.func_230529_a_((ITextComponent)2.wrap(new StringTextComponent("Task Type: " + processor.process.getTaskType()).func_240699_a_(TextFormatting.DARK_AQUA)));
        }
    }
    ,
    TaskInfo{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            text.func_230529_a_((ITextComponent)3.wrap(new StringTextComponent("Task (Main : Light/Total) (" + IProcess.FORMAT.format(processor.gen_speed.getLastValue()) + " : " + IProcess.FORMAT.format(processor.light_speed.getLastValue()) + ") / " + IProcess.FORMAT.format(processor.process.getTotalChunks())).func_240699_a_(TextFormatting.BLUE)));
        }
    }
    ,
    ProcessingSpeed{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            text.func_230529_a_((ITextComponent)4.wrap(new StringTextComponent("Speed (Main | Light): " + ItemStack.field_111284_a.format(processor.mainQueue.isNotWorking() && processor.process.isDone() ? 0.0 : (double)processor.gen_speed.getTotalValue()) + " Chunks/t | " + ItemStack.field_111284_a.format(processor.lightQueue.isNotWorking() ? 0.0 : (double)processor.light_speed.getTotalValue()) + " Chunks/t").func_240699_a_(TextFormatting.AQUA)));
        }
    }
    ,
    LoadedFiles{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            text.func_230529_a_((ITextComponent)5.wrap(new StringTextComponent("Loaded (Chunks | RegionFiles | POI): " + processor.process.getLoadedChunks() + " | " + processor.process.getActiveRegionFiles() + " | " + processor.process.getPointsOfInterest()).func_240699_a_(TextFormatting.GOLD)));
        }
    }
    ,
    ExpectedTime{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            long total = processor.process.getTotalChunks();
            long normalLeft = (long)((float)(total - processor.normalDone) / processor.gen_speed.getTotalValue()) * 50L;
            long lightLeft = (long)((float)(total - processor.lightDone) / processor.light_speed.getTotalValue()) * 50L;
            text.func_230529_a_((ITextComponent)6.wrap(new StringTextComponent("Time Left (Main | Light), Running: " + this.getTime(normalLeft) + " | " + this.getTime(lightLeft) + ", " + processor.getTime()).func_240699_a_(TextFormatting.GREEN)));
        }
    }
    ,
    RamUsage{

        @Override
        public void append(IFormattableTextComponent text, ChunkProcessor processor) {
            text.func_230529_a_((ITextComponent)7.wrap(new StringTextComponent("Ram Usage: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "MB").func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        }
    };


    public static IFormattableTextComponent wrap(IFormattableTextComponent text) {
        return new StringTextComponent("[").func_230529_a_((ITextComponent)text).func_240702_b_("]");
    }

    protected String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)"HH:mm:ss");
    }

    public void append(IFormattableTextComponent text, ChunkProcessor processor) {
    }

    public static String toPascalCase(String input) {
        StringBuilder builder = new StringBuilder();
        for (String s : input.replaceAll("_", " ").replaceAll("-", " ").split(" ")) {
            builder.append(ChunkLogger.firstLetterUppercase(s)).append(" ");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static String firstLetterUppercase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String first = Character.toString(string.charAt(0));
        return string.replaceFirst(first, first.toUpperCase());
    }
}

