/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.File;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.LongPredicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.DimensionType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionSectionCache;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.base.PregenEvent;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.GeneratorQueue;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.collections.Long2ObjectCustomMap;
import pregenerator.common.utils.misc.ReflectionHelper;
import pregenerator.common.utils.misc.TrackedRegionFile;

public class ChunkProcess
implements IInteruptable {
    public static final Runnable EMPTY = () -> {};
    public static final BooleanSupplier FALSE = () -> false;
    private static final Method FLIP_CHUNKS = ReflectionHelper.findMethod(ServerChunkProvider.class, new String[]{"func_217235_l"}, new Class[0]);
    private static final Method GET_CHUNK = ReflectionHelper.findMethod(ServerChunkProvider.class, new String[]{"func_217213_a"}, Long.TYPE);
    private static final TicketType<ChunkPos> PREGEN_TICKET = TicketType.func_219484_a((String)"chunkpregen", Comparator.comparingLong(ChunkPos::func_201841_a));
    private GenerationType genType;
    private ObjectArrayList<ChunkEntry> tasks = ObjectArrayList.wrap((Object[])new ChunkEntry[0]);
    private ServerWorld world;
    private ServerChunkProvider provider;
    private ChunkManager manager;
    private TicketManager ticketing;
    private File regionFolder;
    private GenTaskStorage.ExecutionMemory memory;
    private Long2ObjectLinkedOpenHashMap<RegionFile> cache;
    private ITaskExecutor<ChunkTaskPriorityQueueSorter.RunnableEntry> lightTasks;
    private Long2ObjectMap<Optional<PointOfInterestData>> pointsOfInterest;
    int spawnX;
    int spawnZ;
    private long totalChunks = 0L;
    private boolean throwEvents = false;

    public ChunkProcess(ServerWorld world, GenerationType genType) {
        this.world = world;
        this.genType = genType;
        BlockPos pos = world.func_241135_u_();
        this.spawnX = pos.func_177958_n() >> 4;
        this.spawnZ = pos.func_177952_p() >> 4;
        this.provider = world.func_72863_F();
        this.manager = this.provider.field_217237_a;
        this.ticketing = ReflectionHelper.getValueSave(ServerChunkProvider.class, this.provider, TicketManager.class);
        this.regionFolder = new File(DimensionType.func_236031_a_((RegistryKey)world.func_234923_W_(), (File)world.func_73046_m().func_240776_a_(FolderName.field_237253_i_).getParent().toFile()), "region");
        if (!this.regionFolder.exists()) {
            this.regionFolder.mkdirs();
        }
        if (this.ticketing == null) {
            throw new IllegalStateException("Ticket System couldn't be fetched");
        }
        this.lightTasks = (ITaskExecutor)ReflectionHelper.getValueSave(TicketManager.class, this.ticketing, "field_219386_n");
        if (this.lightTasks == null) {
            throw new IllegalStateException("Light Tasks couldn't be fetched");
        }
        this.cache = this.getCache(this.provider);
        if (this.cache == null) {
            throw new IllegalStateException("Could not access the Region File Cache for faster Managment");
        }
        Long2ObjectMap map = (Long2ObjectMap)ReflectionHelper.getValueSave(RegionSectionCache.class, this.provider.func_217231_i(), new String[]{"data", "field_219121_b"});
        if (map instanceof Long2ObjectCustomMap) {
            this.pointsOfInterest = map;
        } else {
            this.pointsOfInterest = new Long2ObjectCustomMap(map);
            ReflectionHelper.setValueSave(RegionSectionCache.class, this.provider.func_217231_i(), this.pointsOfInterest, "data", "field_219121_b");
        }
    }

    public void init(Long2ObjectMap<BitSet> maps, ChunkPos center, String taskName, boolean event, IProcess.PrepaireProgress progress) {
        if (!progress.isAlive()) {
            return;
        }
        this.memory = TaskStorage.getGenStorage().getMemory(taskName);
        progress.growMax(maps.size());
        this.tasks.ensureCapacity(maps.size());
        this.clearFiles();
        RegionProvider region = new RegionProvider(this);
        LongPredicate tester = null;
        if (event) {
            PregenEvent.PregenCheckEvent check = new PregenEvent.PregenCheckEvent(this.world);
            MinecraftForge.EVENT_BUS.post((Event)check);
            tester = check.getPredicate();
        }
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(maps)) {
            progress.growValue(1);
            ChunkEntry task = new ChunkEntry(this, new ChunkPos(ChunkPos.func_212578_a((long)entry.getLongKey()) << 5, ChunkPos.func_212579_b((long)entry.getLongKey()) << 5), (BitSet)entry.getValue());
            if (task.init(region, event, tester)) continue;
            this.tasks.add((Object)task);
            this.totalChunks += (long)task.getTotalSize();
        }
        ObjectArrays.parallelQuickSort((Object[])this.tasks.elements(), (int)0, (int)this.tasks.size(), (o1, o2) -> Long.compare(o2.getDistanceToCenter(center), o1.getDistanceToCenter(center)));
        if (this.genType.requiresAccurateScan()) {
            Executor exe = Util.func_215072_e();
            ChunkEntry[] entries = (ChunkEntry[])this.tasks.elements();
            int m = this.tasks.size();
            for (int i = 0; i < m; ++i) {
                entries[i].checkAccuratly(exe);
            }
        }
        this.provider.func_212863_j_().func_215598_a(1000);
    }

    public void onTaskFinished() {
        this.provider.func_212863_j_().func_215598_a(5);
        this.clearFiles();
    }

    @Override
    public void interrupt() {
        int m = this.tasks.size();
        for (int i = 0; i < m; ++i) {
            ((ChunkEntry)this.tasks.get(i)).interrupt();
        }
        this.tasks.clear();
        this.onTaskFinished();
    }

    public void onTick() {
        if (this.world.func_82737_E() % 80L == 0L) {
            if (this.pointsOfInterest.size() > 50000) {
                long start = System.currentTimeMillis();
                PointOfInterestManager manager = this.provider.func_217231_i();
                LongIterator iter = this.pointsOfInterest.keySet().iterator();
                while (iter.hasNext() && this.pointsOfInterest.size() > 50000 && System.currentTimeMillis() - start < 2L) {
                    long value = iter.nextLong();
                    ChunkPos pos = SectionPos.func_218170_a((long)value).func_218155_u();
                    manager.func_219112_a(pos);
                    iter.remove();
                }
            }
            while (this.cache.size() > 50) {
                try {
                    ((RegionFile)this.cache.removeLast()).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isValidating() {
        return this.tasks.size() > 0 && ((ChunkEntry)this.tasks.top()).isValidating();
    }

    public int getPointsOfInterest() {
        return this.pointsOfInterest.size();
    }

    public void drainIntoQueue(GeneratorQueue queue) {
        if (this.tasks.isEmpty()) {
            return;
        }
        while (this.tasks.size() > 0 && queue.enqueue((ChunkEntry)this.tasks.top())) {
            this.tasks.pop();
        }
    }

    public void startTask(long[] chunks, ChunkStatus requestedStatus, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] adder) {
        int i;
        int finalStatus = 33 + ChunkStatus.func_222599_a((ChunkStatus)requestedStatus);
        int m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.func_219356_a(PREGEN_TICKET, pos, finalStatus, (Object)pos);
        }
        this.flipChunks();
        m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkHolder chunkholder = ChunkProcess.getHolder(this.provider, chunks[i]);
            if (chunkholder == null || chunkholder.func_219299_i() > finalStatus) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
            adder[i] = chunkholder.func_219276_a(requestedStatus, this.manager);
        }
    }

    public void startTask(long[] chunks, int radius, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] adder) {
        int i;
        int finalStatus = 33 - radius;
        int m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.func_219356_a(PREGEN_TICKET, pos, finalStatus, (Object)pos);
        }
        this.flipChunks();
        m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkHolder chunkholder = ChunkProcess.getHolder(this.provider, chunks[i]);
            if (chunkholder == null || chunkholder.func_219299_i() > finalStatus) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
            adder[i] = chunkholder.func_219276_a(ChunkStatus.field_222617_m, this.manager);
        }
    }

    public void finishTickets(long[] chunks, int start, int end, ChunkStatus statusToRemove) {
        int status = 33 + ChunkStatus.func_222599_a((ChunkStatus)statusToRemove);
        boolean light = statusToRemove == ChunkStatus.field_222617_m || !this.genType.hasSubTask();
        int m = end;
        for (int i = start; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.func_219345_b(PREGEN_TICKET, pos, status, (Object)pos);
            if (light) {
                this.getProvider().func_212863_j_().func_223115_b(pos, false);
            }
            this.lightTasks.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219073_a((Runnable)EMPTY, (long)chunks[i], (boolean)false));
        }
    }

    public void finishTickets(long[] chunks, int start, int end, int radius) {
        int status = 33 - radius;
        int m = end;
        for (int i = start; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.func_219345_b(PREGEN_TICKET, pos, status, (Object)pos);
            this.getProvider().func_212863_j_().func_223115_b(pos, false);
            this.lightTasks.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219073_a((Runnable)EMPTY, (long)chunks[i], (boolean)false));
        }
    }

    private void flipChunks() {
        try {
            FLIP_CHUNKS.invoke((Object)this.provider, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean containsChunk(ServerChunkProvider provider, long value) {
        return ChunkProcess.getHolder(provider, value) != null;
    }

    public static ChunkHolder getHolder(ServerChunkProvider provider, long key) {
        try {
            return (ChunkHolder)GET_CHUNK.invoke((Object)provider, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDone() {
        return this.tasks.isEmpty();
    }

    public boolean isThrowingEvents() {
        return this.throwEvents;
    }

    public GenerationType getTaskType() {
        return this.genType;
    }

    public ServerChunkProvider getProvider() {
        return this.provider;
    }

    public int getLoadedChunks() {
        return this.manager.func_219194_d();
    }

    public long getTotalChunks() {
        return this.totalChunks;
    }

    public int getActiveRegionFiles() {
        return this.cache == null ? 0 : this.cache.size();
    }

    public GenTaskStorage.ExecutionMemory getMemory() {
        return this.memory;
    }

    public ChunkManager getManager() {
        return this.manager;
    }

    public TicketManager getTicketing() {
        return this.ticketing;
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public boolean isSpawn(int x, int z) {
        return Math.abs(this.spawnZ - z) <= 12 && Math.abs(this.spawnX - x) <= 12;
    }

    public TrackedRegionFile getFile(ChunkPos pos) {
        try {
            File file;
            while (this.cache.size() >= 100) {
                ((RegionFile)this.cache.removeLast()).close();
            }
            long data = ChunkPos.func_77272_a((int)pos.func_222241_h(), (int)pos.func_222242_i());
            RegionFile parent = (RegionFile)this.cache.getAndMoveToFirst(data);
            if (parent instanceof TrackedRegionFile && ((TrackedRegionFile)parent).isValid()) {
                return (TrackedRegionFile)parent;
            }
            if (parent != null) {
                this.cache.remove(data);
                try {
                    parent.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((file = new File(this.regionFolder, "r." + pos.func_222241_h() + "." + pos.func_222242_i() + ".mca")).exists()) {
                TrackedRegionFile region = new TrackedRegionFile(file, file.getParentFile());
                this.cache.putAndMoveToFirst(data, (Object)region);
                return region;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> getChunk(long pos) {
        ChunkHolder holder = ChunkProcess.getHolder(this.provider, pos);
        return holder == null ? null : holder.func_219276_a(ChunkStatus.field_222617_m, this.manager);
    }

    private void clearFiles() {
        ObjectArrayList files = new ObjectArrayList(this.cache.values());
        this.cache.clear();
        int m = files.size();
        for (int i = 0; i < m; ++i) {
            try {
                ((RegionFile)files.get(i)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class RegionProvider {
        static final BitSet EMPTY = new BitSet(0);
        static final BitSet FULL = RegionProvider.create();
        Long2ObjectMap<BitSet> map = new Long2ObjectOpenHashMap();
        ChunkProcess process;

        public RegionProvider(ChunkProcess process) {
            this.process = process;
        }

        public boolean getChunk(int chunkX, int chunkZ) {
            return this.get(chunkX, chunkZ).get((chunkZ & 0x1F) * 32 + (chunkX & 0x1F));
        }

        public BitSet get(int chunkX, int chunkZ) {
            BitSet set = (BitSet)this.map.get(ChunkPos.func_77272_a((int)(chunkX >> 5), (int)(chunkZ >> 5)));
            if (set == null) {
                TrackedRegionFile file = this.process.getFile(new ChunkPos(chunkX, chunkZ));
                if (file != null) {
                    set = new BitSet(1024);
                    set.clear();
                    for (int i = 0; i < 1024; ++i) {
                        boolean result = file.func_222667_d(new ChunkPos(i % 32, i / 32));
                        if (!result) continue;
                        set.set(i);
                    }
                    if (set.equals(FULL)) {
                        set = FULL;
                    }
                    this.map.put(ChunkPos.func_77272_a((int)(chunkX >> 5), (int)(chunkZ >> 5)), (Object)set);
                } else {
                    this.map.put(ChunkPos.func_77272_a((int)(chunkX >> 5), (int)(chunkZ >> 5)), (Object)EMPTY);
                    set = EMPTY;
                }
            }
            return set;
        }

        static BitSet create() {
            BitSet set = new BitSet(1024);
            set.set(0, 1023);
            return set;
        }
    }
}

