/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pregenerator.ChunkPregenerator;

public class RetrogenManager {
    public static final RetrogenManager INSTANCE = new RetrogenManager();
    Set<ResourceLocation> activeFeatures = new ObjectLinkedOpenHashSet();

    public Set<ResourceLocation> getInactiveFeatures() {
        ObjectLinkedOpenHashSet locations = new ObjectLinkedOpenHashSet((Collection)ForgeRegistries.FEATURES.getKeys());
        locations.removeAll(this.activeFeatures);
        return locations;
    }

    public Set<ResourceLocation> getActiveFeatures() {
        return new ObjectLinkedOpenHashSet(this.activeFeatures);
    }

    public void enableFeature(ResourceLocation location) {
        this.activeFeatures.add(location);
    }

    public void disableFeature(ResourceLocation location) {
        this.activeFeatures.remove(location);
    }

    public boolean isActive(ResourceLocation location) {
        return this.activeFeatures.contains(location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onSyncPacket(Set<ResourceLocation> active) {
        this.activeFeatures.clear();
        this.activeFeatures.addAll(active);
    }

    public void retrogenChunks(Chunk chunk, List<IChunk> chunks) {
        if (this.activeFeatures.isEmpty()) {
            return;
        }
        BlockPos pos = chunk.func_76632_l().func_206849_h().func_177982_a(8, 8, 8);
        int x = pos.func_177958_n() - 8;
        int z = pos.func_177952_p() - 8;
        try {
            ServerWorld world = (ServerWorld)chunk.func_177412_p();
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            long i1 = sharedseedrandom.func_202424_a(world.func_72905_C(), x, z);
            ChunkGenerator generator = world.func_72863_F().func_201711_g();
            WorldGenRegion region = new WorldGenRegion(world, chunks);
            Biome biome = chunk.func_225549_i_().func_225526_b_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            for (GenerationStage.Decoration generationstage$decoration : GenerationStage.Decoration.values()) {
                try {
                    this.decorate(biome, generationstage$decoration, generator, (ISeedReader)region, i1, sharedseedrandom, pos);
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
                    crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)chunk.func_76632_l().field_77276_a).func_71507_a("CenterZ", (Object)chunk.func_76632_l().field_77275_b).func_71507_a("Step", (Object)generationstage$decoration).func_71507_a("Seed", (Object)i1).func_71507_a("Biome", (Object)ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)).func_71507_a("Chunk Pregenerator Gen", (Object)true);
                    throw new ReportedException(crashreport);
                }
            }
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.catching((Throwable)e);
        }
    }

    private void decorate(Biome biome, GenerationStage.Decoration stage, ChunkGenerator chunkGenerator, ISeedReader worldIn, long seed, SharedSeedRandom random, BlockPos pos) {
        int i = 0;
        for (Supplier feature : (List)biome.func_242440_e().func_242498_c().get(stage.ordinal())) {
            ConfiguredFeature configuredfeature = (ConfiguredFeature)feature.get();
            if (!this.activeFeatures.contains(configuredfeature.field_222737_a.getRegistryName())) {
                ++i;
                continue;
            }
            random.func_202426_b(seed, i, stage.ordinal());
            try {
                configuredfeature.func_242765_a(worldIn, chunkGenerator, (Random)random, pos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Feature placement");
                crashreport.func_85058_a("Feature").func_71507_a("Id", (Object)ForgeRegistries.FEATURES.getKey((IForgeRegistryEntry)configuredfeature.field_222737_a));
                throw new ReportedException(crashreport);
            }
            ++i;
        }
    }
}

