/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public abstract class BaseTask
implements ITask {
    String name;
    RegistryKey<World> type;
    int genType;
    boolean throwEvents;

    public BaseTask(CompoundNBT nbt) {
        this(nbt.func_74779_i("name"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))), nbt.func_74762_e("genType"));
        this.throwEvents = nbt.func_74767_n("events");
    }

    public BaseTask(String name, RegistryKey<World> type, int genType) {
        this.name = name;
        this.type = type;
        this.genType = genType;
    }

    public BaseTask setThrowEvents() {
        this.throwEvents = true;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RegistryKey<World> getDimension() {
        return this.type;
    }

    @Override
    public int getGenType() {
        return this.genType;
    }

    @Override
    public IFormattableTextComponent getTaskDescription() {
        StringTextComponent text = new StringTextComponent("[");
        ITask.convert("Name=" + this.getName() + ", ", (IFormattableTextComponent)text, TextFormatting.AQUA);
        ITask.convert("Dim=" + this.getDimension().getRegistryName().func_110623_a() + ", ", (IFormattableTextComponent)text, TextFormatting.GREEN);
        ITask.convert("GenType=" + GenerationType.values()[this.genType].name() + ", ", (IFormattableTextComponent)text, new TextFormatting[0]);
        this.append((IFormattableTextComponent)text);
        return text.func_240702_b_("]");
    }

    public abstract void append(IFormattableTextComponent var1);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("dim", this.type.func_240901_a_().toString());
        nbt.func_74774_a("genType", (byte)this.genType);
        if (this.throwEvents) {
            nbt.func_74757_a("events", this.throwEvents);
        }
        return nbt;
    }

    @Override
    public void onCompletion(Duration terrainTime, Duration lightTime, long totalChunks) {
    }

    @Override
    public CompletableFuture<ChunkProcess> createTask(ServerWorld world, Executor exe, IProcess.PrepaireProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    public abstract ChunkProcess createTask(ServerWorld var1, IProcess.PrepaireProgress var2);
}

