/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import java.time.Duration;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.IProcess;

public class BenchmarkTask
extends BaseTask {
    boolean small;

    public BenchmarkTask(CompoundNBT nbt) {
        super(nbt);
        this.small = nbt.func_74767_n("small");
    }

    public BenchmarkTask(String name, RegistryKey<World> type, boolean small) {
        super(name, type, GenerationType.FAST_CHECK_GEN.getIndex());
        this.small = small;
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public String getShapeName() {
        return "Benchmark";
    }

    @Override
    public long getTaskSize() {
        return this.small ? 40000L : 250000L;
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ITask.convert("Type=Benchmark, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("Radius=" + (this.small ? 100 : 250), builder, TextFormatting.BLUE);
    }

    @Override
    public ChunkProcess createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        process.init(ChunkShapeBuilder.getSquareShape(0, 0, this.small ? 100 : 250, progress), new ChunkPos(0, 0), this.name, this.throwEvents, progress);
        return process;
    }

    @Override
    public void onCompletion(Duration terrainTime, Duration lightTime, long totalChunks) {
        BenchmarkManager.INSTANCE.addBenchmarkResult(this.getTaskSize(), totalChunks, lightTime, terrainTime, this.small, (RegistryKey<World>)this.type);
    }
}

