/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class CircleExpansionTask
extends BaseTask {
    long center;
    int minRadius;
    int maxRadius;

    public CircleExpansionTask(CompoundNBT nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.minRadius = nbt.func_74762_e("min_radius");
        this.maxRadius = nbt.func_74762_e("max_radius");
    }

    public CircleExpansionTask(String name, RegistryKey<World> type, int genType, ChunkPos center, int minRadius, int maxRadius) {
        super(name, type, genType);
        this.center = center.func_201841_a();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public String getShapeName() {
        return "Circle_Expansion";
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Circle Expansion, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.field_77276_a + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=" + center.field_77275_b + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.minRadius + ", ", builder, TextFormatting.BLUE);
        ITask.convert("MaxRadius=" + this.maxRadius, builder, TextFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        return (long)((double)((long)this.maxRadius * 2L) * Math.PI) - (long)((double)((long)this.minRadius * 2L) * Math.PI);
    }

    @Override
    public ChunkProcess createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos center = new ChunkPos(this.center);
        process.init(ChunkShapeBuilder.getCircleExpansionShape(center.field_77276_a, center.field_77275_b, this.minRadius, this.maxRadius, progress), center, this.name, this.throwEvents, progress);
        return process;
    }
}

