/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class SquareTask
extends BaseTask {
    long center;
    int radius;

    public SquareTask(CompoundNBT nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.radius = nbt.func_74762_e("radius");
    }

    public SquareTask(String name, RegistryKey<World> type, int genType, ChunkPos center, int radius) {
        super(name, type, genType);
        this.center = center.func_201841_a();
        this.radius = radius;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public String getShapeName() {
        return "Square";
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Square, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.field_77276_a + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=" + center.field_77275_b + ", ", builder, TextFormatting.YELLOW);
        ITask.convert("Radius=" + this.radius, builder, TextFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        long diameter = (long)this.radius * 2L;
        return diameter * diameter;
    }

    @Override
    public ChunkProcess createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos center = new ChunkPos(this.center);
        process.init(ChunkShapeBuilder.getSquareShape(center.field_77276_a, center.field_77275_b, this.radius, progress), center, this.name, this.throwEvents, progress);
        return process;
    }
}

