/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class WorldBorderTask
extends BaseTask {
    public WorldBorderTask(CompoundNBT nbt) {
        super(nbt);
    }

    public WorldBorderTask(String name, RegistryKey<World> type, int genType) {
        super(name, type, genType);
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String getShapeName() {
        return "Square";
    }

    @Override
    public long getTaskSize() {
        long diameter = (long)ServerLifecycleHooks.getCurrentServer().func_71218_a(this.type).func_175723_af().func_177741_h();
        return diameter * diameter;
    }

    @Override
    public void append(IFormattableTextComponent builder) {
        ITask.convert("Type=WorldBorder, ", builder, TextFormatting.DARK_PURPLE);
        ITask.convert("X=0, ", builder, TextFormatting.YELLOW);
        ITask.convert("Z=0, ", builder, TextFormatting.YELLOW);
        ITask.convert("Radius=" + ((int)(ServerLifecycleHooks.getCurrentServer().func_71218_a(this.type).func_175723_af().func_177741_h() / 2.0) >> 4), builder, TextFormatting.BLUE);
    }

    @Override
    public ChunkProcess createTask(ServerWorld world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        WorldBorder border = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.type).func_175723_af();
        ChunkPos pos = new ChunkPos((int)border.func_230316_a_() >> 4, (int)border.func_230317_b_() >> 4);
        process.init(ChunkShapeBuilder.getSquareShape(pos.field_77276_a, pos.field_77275_b, (int)(border.func_177741_h() / 2.0) >> 4, progress), pos, this.name, this.throwEvents, progress);
        return process;
    }
}

