/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Dimension;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.utils.misc.ReflectionHelper;

public class DimensionManager {
    static final Field STATUS_LISTENER = ReflectionHelper.findField(ChunkManager.class, "field_219266_t", "field_219266_t");
    static final Field LEVEL_SAVE = ReflectionHelper.findField(MinecraftServer.class, "anvilConverterForAnvilFile", "field_71310_m");
    static final Field SERVER_TIME = ReflectionHelper.findField(MinecraftServer.class, "serverTime", "field_211151_aa");
    public static final DimensionManager INSTANCE = new DimensionManager();

    public void disableDimension(RegistryKey<World> dimension, Consumer<ITextComponent> listener) {
        if (this.canUnloadDimension(ServerLifecycleHooks.getCurrentServer(), dimension, listener) && DimensionRegistry.getRegistry().addDimension(dimension.func_240901_a_())) {
            listener.accept((ITextComponent)new StringTextComponent("Unloading: [" + ChunkLogger.toPascalCase(dimension.func_240901_a_().func_110623_a()) + "]"));
            this.unloadDimension(ServerLifecycleHooks.getCurrentServer(), dimension);
            listener.accept((ITextComponent)new StringTextComponent("Unloaded: [" + ChunkLogger.toPascalCase(dimension.func_240901_a_().func_110623_a()) + "]"));
        }
    }

    public void enableDimension(RegistryKey<World> dimension, Consumer<ITextComponent> listener) {
        if (DimensionRegistry.getRegistry().removeDimension(dimension.func_240901_a_())) {
            listener.accept((ITextComponent)new StringTextComponent("Loading: [" + ChunkLogger.toPascalCase(dimension.func_240901_a_().func_110623_a()) + "]"));
            this.loadDimension(ServerLifecycleHooks.getCurrentServer(), dimension);
            listener.accept((ITextComponent)new StringTextComponent("Loaded: [" + ChunkLogger.toPascalCase(dimension.func_240901_a_().func_110623_a()) + "]"));
        } else {
            listener.accept((ITextComponent)new StringTextComponent("Dimension [" + ChunkLogger.toPascalCase(dimension.func_240901_a_().func_110623_a()) + "] already enabled").func_240699_a_(TextFormatting.RED));
        }
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        DimensionRegistry registry = DimensionRegistry.getRegistry();
        for (ResourceLocation dim : registry.getDims()) {
            this.syncTime(server);
            this.unloadDimension(server, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim));
        }
    }

    private boolean canUnloadDimension(MinecraftServer server, RegistryKey<World> world, Consumer<ITextComponent> listener) {
        if (World.field_234918_g_.func_240901_a_().equals((Object)world.func_240901_a_())) {
            listener.accept((ITextComponent)new StringTextComponent("Can not Unload the Overworld"));
            return false;
        }
        ServerWorld serverWorld = server.func_71218_a(world);
        if (serverWorld == null) {
            listener.accept((ITextComponent)new StringTextComponent("World [" + ChunkLogger.toPascalCase(world.func_240901_a_().func_110623_a()) + "] does not exist"));
            return false;
        }
        if (serverWorld.func_217369_A().size() > 0) {
            listener.accept((ITextComponent)new StringTextComponent("Can not unload a Dimension if Players are present"));
            return false;
        }
        return true;
    }

    private void loadDimension(MinecraftServer server, RegistryKey<World> world) {
        IServerConfiguration config = server.func_240793_aU_();
        DimensionGeneratorSettings settings = config.func_230418_z_();
        Dimension dim = (Dimension)settings.func_236224_e_().func_230516_a_(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)world.func_240901_a_()));
        ServerWorld serverWorld = new ServerWorld(server, Util.func_215072_e(), this.getLevelSave(server), (IServerWorldInfo)new DerivedWorldInfo(config, config.func_230407_G_()), world, dim.func_236063_b_(), this.getStatusListener(server), dim.func_236064_c_(), settings.func_236227_h_(), BiomeManager.func_235200_a_((long)settings.func_236221_b_()), (List)ImmutableList.of(), false);
        server.func_71218_a(World.field_234918_g_).func_175723_af().func_177737_a((IBorderListener)new IBorderListener.Impl(serverWorld.func_175723_af()));
        server.forgeGetWorldMap().put(world, serverWorld);
        server.markWorldsDirty();
    }

    private void unloadDimension(MinecraftServer server, RegistryKey<World> key) {
        ServerWorld world = server.func_71218_a(key);
        if (world == null) {
            return;
        }
        world.func_217445_a(null, true, false);
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)world));
        try {
            world.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.forgeGetWorldMap().remove(key);
        server.markWorldsDirty();
    }

    private SaveFormat.LevelSave getLevelSave(MinecraftServer server) {
        try {
            return (SaveFormat.LevelSave)LEVEL_SAVE.get(server);
        }
        catch (Exception e) {
            throw new IllegalStateException("LevelSave is not accessible!", e);
        }
    }

    private IChunkStatusListener getStatusListener(MinecraftServer server) {
        try {
            return (IChunkStatusListener)STATUS_LISTENER.get(server.func_71218_a((RegistryKey)World.field_234918_g_).func_72863_F().field_217237_a);
        }
        catch (Exception e) {
            throw new IllegalStateException("ChunkStatusListener is not accessible!", e);
        }
    }

    public void syncTime(MinecraftServer server) {
        try {
            SERVER_TIME.setLong(server, Util.func_211177_b() + 100L);
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.warn("Couldn't Sync ServerTime", (Throwable)e);
        }
    }

    public static class DimensionRegistry
    extends WorldSavedData {
        ObjectSet<ResourceLocation> locations = new ObjectLinkedOpenHashSet();

        public DimensionRegistry() {
            super("pregen_dimensions");
        }

        public static DimensionRegistry getRegistry() {
            return (DimensionRegistry)ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(DimensionRegistry::new, "pregen_dimensions");
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.locations.clear();
            ListNBT list = nbt.func_150295_c("dimensions", 8);
            int i = 0;
            while (i < list.size()) {
                this.locations.add((Object)new ResourceLocation(list.func_150307_f(i++)));
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            ListNBT list = new ListNBT();
            for (ResourceLocation location : this.locations) {
                list.add((Object)StringNBT.func_229705_a_((String)location.toString()));
            }
            compound.func_218657_a("dimensions", (INBT)list);
            return compound;
        }

        public boolean addDimension(ResourceLocation location) {
            if (!World.field_234918_g_.func_240901_a_().equals((Object)location) && this.locations.add((Object)location)) {
                this.func_76185_a();
                return true;
            }
            return false;
        }

        public boolean removeDimension(ResourceLocation location) {
            if (this.locations.remove((Object)location)) {
                this.func_76185_a();
                return true;
            }
            return false;
        }

        public Iterable<ResourceLocation> getDims() {
            return () -> ObjectIterators.unmodifiable((ObjectIterator)this.locations.iterator());
        }
    }
}

