/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.IOWorker;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.PregenConfig;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.base.ListenerStorage;
import pregenerator.common.base.ProcessListener;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.DeletionProcessor;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.TaskQueue;
import pregenerator.common.utils.collections.SynchronizedLong2ObjectLinkedOpenHashMap;
import pregenerator.common.utils.misc.ReflectionHelper;

public class ServerManager {
    public static final ServerManager INSTANCE = new ServerManager();
    Object2ObjectMap<RegistryKey<World>, IProcess<?, ?>> processor = new Object2ObjectLinkedOpenHashMap();
    TaskQueue<ChunkProcess, ITask, ChunkProcessor> generation = new TaskQueue(true, ChunkProcessor.class, (Map<RegistryKey<World>, IProcess<?, ?>>)this.processor, TaskStorage::getGenStorage);
    TaskQueue<ChunkDeleter, IDeletionTask, DeletionProcessor> deletion = new TaskQueue(false, DeletionProcessor.class, (Map<RegistryKey<World>, IProcess<?, ?>>)this.processor, TaskStorage::getDeletionStorage);
    Set<ProcessListener> listeners = new ObjectLinkedOpenHashSet();
    int size;
    boolean aggressive;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        int index = (Integer)PregenConfig.INSTANCE.threadingRule.get();
        int cores = Runtime.getRuntime().availableProcessors();
        this.size = index == 0 ? 1 : Math.max(1, index == 1 ? cores / 2 : Math.round((float)cores / 1.5f));
        this.generation.populate(this.size, (Supplier<ChunkProcessor>)((Supplier)ChunkProcessor::new));
        this.deletion.populate(this.size, (Supplier<DeletionProcessor>)((Supplier)DeletionProcessor::new));
        this.aggressive = (Boolean)PregenConfig.INSTANCE.agressiveGeneration.get();
    }

    public boolean isAggressive() {
        return this.aggressive;
    }

    public int getProcessors() {
        return this.size;
    }

    public long getSeed() {
        return this.getServer().func_71218_a(World.field_234918_g_).func_72905_C();
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public boolean hasRetroBlockingTask() {
        for (IProcess process : this.processor.values()) {
            if (!process.isBlockingRetrogen()) continue;
            return true;
        }
        return false;
    }

    public int startTask(IBaseTask<?> task, UUID id, Consumer<ITextComponent> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((ITextComponent)new StringTextComponent("Benchmark Running. Can not Run anything else in the meantime"));
            return 0;
        }
        if (task instanceof ITask) {
            if (this.generation.startTask((ITask)task, listener, this.getServer())) {
                this.updateListeners(id, true);
            }
        } else if (task instanceof IDeletionTask && this.deletion.startTask((IDeletionTask)task, listener, this.getServer())) {
            this.updateListeners(id, true);
        }
        this.updateAutoRestart();
        return 0;
    }

    public int pauseTask(String taskName, Consumer<ITextComponent> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((ITextComponent)new StringTextComponent("Benchmark Running. Pause is disabled"));
            return 0;
        }
        boolean found = false;
        for (IProcess entry : this.processor.values()) {
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName()) || !entry.isRunning()) continue;
            entry.pauseTask();
            found = true;
            listener.accept((ITextComponent)new StringTextComponent("Pausing [" + entry.getTaskName() + "] Task"));
        }
        if (!found) {
            listener.accept((ITextComponent)new StringTextComponent("No Tasks Paused"));
        }
        return 0;
    }

    public int resumeTask(String taskName, Consumer<ITextComponent> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((ITextComponent)new StringTextComponent("Benchmark Running. Resume is disabled"));
            return 0;
        }
        boolean found = false;
        for (IProcess entry : this.processor.values()) {
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName()) || entry.isRunning()) continue;
            entry.resumeTask();
            found = true;
            listener.accept((ITextComponent)new StringTextComponent("Resuming [" + entry.getTaskName() + "] Task"));
        }
        if (!found) {
            listener.accept((ITextComponent)new StringTextComponent("No Tasks Resuming"));
        }
        return 0;
    }

    public int stopTask(String taskName, Consumer<ITextComponent> listener, boolean interrupt) {
        boolean found = false;
        ObjectIterator iter = this.processor.values().iterator();
        while (iter.hasNext()) {
            IProcess entry = (IProcess)iter.next();
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName())) continue;
            listener.accept((ITextComponent)new StringTextComponent("Stopping [" + entry.getTaskName() + "] Task"));
            entry.stopTask();
            found = true;
            this.generation.consume(entry);
            this.deletion.consume(entry);
            iter.remove();
        }
        if (!found) {
            listener.accept((ITextComponent)new StringTextComponent("No Tasks Paused"));
        } else {
            this.listeners.clear();
        }
        if (!this.isRunning() && !interrupt) {
            ForgeConfigSpec.BooleanValue value = PregenConfig.INSTANCE.autoRestart;
            value.set((Object)false);
            value.save();
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            BenchmarkManager.INSTANCE.interruptBenchmark();
        }
        return 0;
    }

    public int removeTask(String taskName, Consumer<ITextComponent> listener) {
        this.stopTask(taskName, listener, false);
        int total = this.generation.removeTasks(taskName) + this.deletion.removeTasks(taskName);
        listener.accept((ITextComponent)new StringTextComponent(total > 0 ? "Deleted [" + total + "] Tasks" : "No Tasks Deleted"));
        return 0;
    }

    public int continueTask(String name, UUID id, Consumer<ITextComponent> listener) {
        if (this.deletion.continueTask(name, listener, this.getServer())) {
            this.updateListeners(id, true);
            this.updateAutoRestart();
        } else if (this.generation.continueTask(name, listener, this.getServer())) {
            this.updateListeners(id, true);
            this.updateAutoRestart();
        }
        return 0;
    }

    public int continueTask(Consumer<ITextComponent> listener) {
        this.updateListeners(null, true);
        MinecraftServer server = this.getServer();
        boolean found = true;
        while (this.deletion.findNextTask(listener, server, true)) {
            found = false;
        }
        if (found) {
            while (this.generation.findNextTask(listener, server, true)) {
                found = false;
            }
        }
        this.updateAutoRestart();
        return 0;
    }

    public void onTaskFinished(RegistryKey<World> type) {
        IProcess entry = (IProcess)this.processor.remove(type);
        if (entry != null) {
            this.generation.consume(entry);
            this.deletion.consume(entry);
        }
        this.updateListeners(null, true);
        Consumer<ITextComponent> listener = this::listen;
        MinecraftServer server = this.getServer();
        boolean found = true;
        while (this.deletion.findNextTask(listener, server, true)) {
            found = false;
        }
        if (found) {
            while (this.generation.findNextTask(listener, server, true)) {
                found = false;
            }
        }
        if (found && !this.isRunning()) {
            BenchmarkManager.INSTANCE.onBenchmarksFinished(this::listen);
            this.listeners.clear();
        }
        this.updateAutoRestart();
    }

    public void listen(ITextComponent text) {
        MinecraftServer server = this.getServer();
        for (ProcessListener listener : this.listeners) {
            listener.sendMessage(server, text);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (IProcess process : new ObjectArrayList(this.processor.values())) {
                process.onTickStart();
            }
            return;
        }
        int limit = (Integer)PregenConfig.INSTANCE.playerLimit.get();
        boolean paused = limit >= 0 && limit <= ServerLifecycleHooks.getCurrentServer().func_71233_x();
        for (IProcess process : new ObjectArrayList(this.processor.values())) {
            process.onTickStop(paused);
        }
    }

    public byte[] sendData() {
        if (this.processor.isEmpty()) {
            return new byte[0];
        }
        ByteBuf buf = Unpooled.buffer();
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.writeInt(this.processor.size());
        for (Object2ObjectMap.Entry entry : this.processor.object2ObjectEntrySet()) {
            buffer.func_192572_a(((RegistryKey)entry.getKey()).func_240901_a_());
            ((IProcess)entry.getValue()).sendClientData(buffer);
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        return data;
    }

    public void addListener(UUID id) {
        this.listeners.add(ProcessListener.create(id));
    }

    public void updateListeners(UUID id, boolean triggerAuto) {
        ListenerStorage storage = TaskStorage.getListeners();
        if (!storage.isIgnoring(id)) {
            this.listeners.add(ProcessListener.create(id));
        }
        if (triggerAuto) {
            TaskStorage.getListeners().updateListeners(this.listeners);
        }
    }

    public void removeListener(UUID id) {
        this.listeners.remove(ProcessListener.create(id));
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.removeListener(event.getEntity().func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        UUID id = event.getEntity().func_110124_au();
        if (this.getServer().func_71264_H() && !TaskStorage.getListeners().contains(id)) {
            TaskStorage.getListeners().add(id, (Boolean)PregenConfig.INSTANCE.pregenOverlay.get() == false);
        }
        if (TaskStorage.getListeners().isAutoListening(id)) {
            this.listeners.add(ProcessListener.create(id));
        }
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppingEvent event) {
        this.stopTask(null, T -> {}, true);
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartingEvent event) {
        if (!TaskStorage.getListeners().contains(null)) {
            TaskStorage.getListeners().add(null, true);
        }
        if (((Boolean)PregenConfig.INSTANCE.autoRestart.get()).booleanValue()) {
            this.onTaskFinished(null);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld) {
            try {
                RegionFileCache cache;
                ChunkManager manager = ((ServerWorld)world).func_72863_F().field_217237_a;
                IOWorker worker = ReflectionHelper.getValueSave(ChunkLoader.class, manager, IOWorker.class);
                if (worker != null && (cache = ReflectionHelper.getValueSave(IOWorker.class, worker, RegionFileCache.class)) != null) {
                    ReflectionHelper.setSafeValue(RegionFileCache.class, cache, new SynchronizedLong2ObjectLinkedOpenHashMap((Long2ObjectMap)ReflectionHelper.getValueSave(RegionFileCache.class, cache, 0)), 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateAutoRestart() {
        ForgeConfigSpec.BooleanValue value = PregenConfig.INSTANCE.autoRestart;
        if (((Boolean)value.get()).booleanValue() != this.isRunning()) {
            value.set((Object)this.isRunning());
            value.save();
        }
    }

    public boolean hasProcessorsLeft() {
        return !this.generation.isEmpty();
    }

    public boolean isRunning() {
        return this.processor.size() > 0;
    }

    public boolean isRunning(RegistryKey<World> type) {
        return this.processor.get(type) != null;
    }

    public long[] getData(RegistryKey<World> target) {
        long[] data = new long[6];
        for (IProcess entry : this.processor.values()) {
            if (!(entry instanceof ChunkProcessor)) continue;
            ChunkProcessor process = (ChunkProcessor)entry;
            data[0] = data[0] + process.getTotal();
            data[1] = data[1] + process.getGenDone();
            data[2] = data[2] + process.getLightDone();
        }
        IProcess entry = (IProcess)this.processor.get(target);
        if (entry instanceof ChunkProcessor) {
            ChunkProcessor process = (ChunkProcessor)entry;
            data[3] = data[3] + process.getTotal();
            data[4] = data[4] + process.getGenDone();
            data[5] = data[5] + process.getLightDone();
        }
        return data;
    }

    public boolean isListening(UUID id) {
        return this.listeners.contains(ProcessListener.create(id));
    }
}

