/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.chunk;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.typeRequest.TypeInfoAnswer;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.tracker.TypeEntry;
import pregenerator.common.tracker.WorldTracker;

public class ChunkTypeRequest
implements IPregenPacket {
    int index;
    ResourceLocation dimension;
    long chunk;

    public ChunkTypeRequest() {
    }

    public ChunkTypeRequest(int index, ResourceLocation dimension, long chunk) {
        this.index = index;
        this.dimension = dimension;
        this.chunk = chunk;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.index);
        buffer.func_192572_a(this.dimension);
        buffer.writeLong(this.chunk);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.index = buffer.func_150792_a();
        this.dimension = buffer.func_192575_l();
        this.chunk = buffer.readLong();
    }

    @Override
    public void process(PlayerEntity player) {
        Chunk chunkInstance;
        WorldTracker tracker = ServerTracker.INSTANCE.getWorldTracker((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.dimension));
        Object types = ObjectLists.emptyList();
        if (tracker != null && (chunkInstance = tracker.getChunk(this.chunk)) != null) {
            switch (this.index) {
                case 0: {
                    types = TypeEntry.createChunkTileEntity(chunkInstance);
                    break;
                }
                case 1: {
                    types = TypeEntry.createChunkEntities(chunkInstance);
                    break;
                }
                case 2: {
                    types = TypeEntry.createChunkBiomes(chunkInstance);
                }
            }
        }
        NetworkManager.INSTANCE.sendToPlayer(new TypeInfoAnswer(this.index, (List<TypeEntry>)types), player);
    }
}

