/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.command;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.client.gui.commands.TaskListScreen;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.networking.IPregenPacket;

public class GenTaskListAnswer
implements IPregenPacket {
    int index;
    List<ITask> tasks = new ObjectArrayList();
    Set<String> active = new ObjectLinkedOpenHashSet();

    public GenTaskListAnswer() {
    }

    public GenTaskListAnswer(int index, List<ITask> tasks, Set<String> active) {
        this.index = index;
        this.tasks.addAll(tasks);
        this.active.addAll(active);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.index);
        buffer.func_150787_b(this.tasks.size());
        for (int i = 0; i < this.tasks.size(); ++i) {
            buffer.func_150786_a(ITask.saveTask(this.tasks.get(i)));
        }
        buffer.func_150787_b(this.active.size());
        for (String s : this.active) {
            buffer.func_180714_a(s);
        }
    }

    @Override
    public void read(PacketBuffer buffer) {
        int i;
        this.index = buffer.func_150792_a();
        int size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            this.tasks.add(ITask.loadTask(buffer.func_150793_b()));
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            this.active.add(buffer.func_218666_n());
        }
    }

    @Override
    public void process(PlayerEntity player) {
        this.processClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processClient() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof TaskListScreen) {
            ((TaskListScreen)screen).onTasksReceived(this.index, (List<IBaseTask<?>>)new ObjectArrayList(this.tasks), this.active);
        }
    }
}

