/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.common.structures.StructureRef;
import pregenerator.common.structures.StructureWorld;

public class StructureManager {
    public static final StructureManager INSTANCE = new StructureManager();

    @SubscribeEvent
    public synchronized void onChunkSave(ChunkDataEvent.Save event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        StructureWorld structure = StructureWorld.getStructures((ServerWorld)event.getWorld());
        if (structure == null) {
            return;
        }
        for (StructureStart start : event.getChunk().func_201609_c().values()) {
            structure.addStructure(start.func_214627_k().getRegistryName().toString(), start);
        }
    }

    @SubscribeEvent
    public synchronized void onChunkLoad(ChunkEvent.Load load) {
        IChunk chunk = load.getChunk();
        if (!(chunk instanceof Chunk)) {
            return;
        }
        World world = ((Chunk)chunk).func_177412_p();
        if (world instanceof ServerWorld) {
            StructureWorld structure = StructureWorld.getStructures((ServerWorld)world);
            if (structure == null) {
                return;
            }
            for (StructureStart start : chunk.func_201609_c().values()) {
                structure.addStructure(start.func_214627_k().getRegistryName().toString(), start);
            }
        }
    }

    public synchronized List<StructureRef> getTrackers(RegistryKey<World> type) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return ObjectLists.emptyList();
        }
        ServerWorld world = server.func_71218_a(type);
        if (world == null) {
            return ObjectLists.emptyList();
        }
        ObjectArrayList trackers = new ObjectArrayList();
        StructureWorld structure = StructureWorld.getStructures(world);
        if (structure != null) {
            structure.getStructures(null, (Collection<StructureRef>)trackers);
        }
        return trackers;
    }
}

