/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import com.google.common.base.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.feature.structure.StructureStart;
import pregenerator.common.generator.ChunkLogger;

public class StructureRef {
    String name;
    long pos;
    int components;
    int size;
    int[] bounds;

    public StructureRef(String name, StructureStart<?> start) {
        this.name = name;
        this.pos = ChunkPos.func_77272_a((int)start.func_143019_e(), (int)start.func_143018_f());
        this.components = start.func_186161_c().size();
        this.bounds = start.func_75071_a().func_151535_h().func_150302_c();
        this.size = this.calculateChunkSize();
    }

    public StructureRef(String name, int[] data) {
        this.name = name;
        this.pos = ChunkPos.func_77272_a((int)data[0], (int)data[1]);
        this.components = data[2];
        this.size = data[3];
        this.bounds = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.bounds[i] = data[4 + i];
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pos});
    }

    public boolean equals(Object obj) {
        if (obj instanceof StructureRef) {
            return ((StructureRef)obj).pos == this.pos;
        }
        return false;
    }

    public int[] write() {
        int[] index = new int[10];
        index[0] = ChunkPos.func_212578_a((long)this.pos);
        index[1] = ChunkPos.func_212579_b((long)this.pos);
        index[2] = this.components;
        index[3] = this.size;
        for (int i = 0; i < 6; ++i) {
            index[4 + i] = this.bounds[i];
        }
        return index;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        ResourceLocation location = ResourceLocation.func_208304_a((String)this.name);
        return ChunkLogger.toPascalCase(location.func_110623_a()) + " (" + ChunkLogger.toPascalCase(location.func_110624_b()) + ")";
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public int getSize() {
        return this.size;
    }

    private int calculateChunkSize() {
        int width = this.bounds[3] - this.bounds[0];
        int depth = this.bounds[5] - this.bounds[2];
        return (int)Math.sqrt(width * width + depth * depth);
    }
}

