/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.gen.feature.structure.StructureStart;
import pregenerator.common.structures.StructureRef;

public class StructureTracker {
    String name;
    Set<StructureRef> references = new ObjectLinkedOpenHashSet();

    public StructureTracker(CompoundNBT nbt) {
        this.name = nbt.func_74779_i("name");
        ListNBT list = nbt.func_150295_c("references", 11);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            this.references.add(new StructureRef(this.name, list.func_150306_c(i)));
        }
    }

    public StructureTracker(String name) {
        this.name = name;
    }

    public synchronized void addStructure(StructureStart<?> start) {
        this.references.add(new StructureRef(this.name, start));
    }

    public String getName() {
        return this.name;
    }

    public synchronized Set<StructureRef> getReferences() {
        return this.references;
    }

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        ListNBT list = new ListNBT();
        for (StructureRef ref : this.references) {
            list.add((Object)new IntArrayNBT(ref.write()));
        }
        nbt.func_218657_a("references", (INBT)list);
        return nbt;
    }
}

