/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.PregenConfig;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.utils.misc.AverageCounter;
import pregenerator.common.utils.misc.TimeTracker;

public class ServerTracker {
    public static final ServerTracker INSTANCE = new ServerTracker();
    TimeTracker timer = new TimeTracker(40);
    AverageCounter packets = new AverageCounter(40);
    Object2ObjectMap<RegistryKey<World>, WorldTracker> trackers = new Object2ObjectLinkedOpenHashMap();

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean toggle(boolean newValue) {
        if (this.disabled() == newValue) {
            ForgeConfigSpec.BooleanValue value = PregenConfig.INSTANCE.tracker;
            value.set((Object)newValue);
            value.save();
            return true;
        }
        return false;
    }

    public byte[] getProfilerData(RegistryKey<World> type) {
        if (this.disabled()) {
            return new byte[0];
        }
        ByteBuf buf = Unpooled.buffer();
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_150787_b(this.packets.getAverage());
        buffer.func_150787_b(this.packets.getLast());
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        buffer.func_179254_b(this.timer.getAverage());
        buffer.func_179254_b(this.timer.getLastValue());
        buffer.func_150787_b(this.trackers.size());
        for (Object2ObjectMap.Entry entry : this.trackers.object2ObjectEntrySet()) {
            buffer.func_192572_a(((RegistryKey)entry.getKey()).func_240901_a_());
            buffer.func_179254_b(((WorldTracker)entry.getValue()).getAverageLag());
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get(type);
        buffer.writeBoolean(tracker != null);
        if (tracker != null) {
            tracker.writeTrackingData(buffer);
        }
        byte[] data = new byte[buf.writerIndex()];
        buffer.readBytes(data);
        return data;
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        IWorld world = event.getWorld();
        if (!(world instanceof World)) {
            return;
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get((Object)((World)world).func_234923_W_());
        if (tracker != null) {
            tracker.onBlockUpdate();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.disabled()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.timer.start();
            this.packets.addMore(ServerLifecycleHooks.getCurrentServer().func_223704_be());
            this.packets.onFinished();
            return;
        }
        this.timer.finish();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isClient() || this.disabled()) {
            return;
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get((Object)event.world.func_234923_W_());
        if (tracker != null) {
            if (event.phase == TickEvent.Phase.START) {
                tracker.start();
                return;
            }
            tracker.stop();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld) {
            ServerWorld server = (ServerWorld)world;
            this.trackers.put((Object)server.func_234923_W_(), (Object)new WorldTracker(server));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        this.trackers.remove((Object)((World)event.getWorld()).func_234923_W_());
    }

    protected boolean disabled() {
        return (Boolean)PregenConfig.INSTANCE.tracker.get() == false;
    }

    public Set<ResourceLocation> getAllDimensions() {
        ObjectOpenHashSet locations = new ObjectOpenHashSet();
        for (RegistryKey type : ServerLifecycleHooks.getCurrentServer().func_240770_D_()) {
            locations.add(type.func_240901_a_());
        }
        return locations;
    }

    public Set<ResourceLocation> getLoadedDimensions() {
        ObjectOpenHashSet locations = new ObjectOpenHashSet();
        for (RegistryKey type : this.trackers.keySet()) {
            locations.add(type.func_240901_a_());
        }
        return locations;
    }

    public WorldTracker getWorldTracker(RegistryKey<World> dimension) {
        return (WorldTracker)this.trackers.get(dimension);
    }
}

