/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;

public class CommandBuilder {
    Stack<CommandNode<CommandSource>> queue = new ObjectArrayList();
    CommandNode<CommandSource> current;

    public CommandBuilder(String base) {
        this.current = Commands.func_197057_a((String)base).build();
    }

    public CommandBuilder(String name, ArgumentType<?> type) {
        this.current = Commands.func_197056_a((String)name, type).build();
    }

    public CommandBuilder(ArgumentBuilder<CommandSource, ?> arg) {
        this.current = arg.build();
    }

    public CommandBuilder merge(CommandBuilder builder) {
        CommandNode<CommandSource> arg = builder.build();
        this.current.addChild(arg);
        this.queue.push(this.current);
        this.current = arg;
        return this;
    }

    public CommandBuilder addLiteral(String name) {
        LiteralCommandNode arg = Commands.func_197057_a((String)name).build();
        this.current.addChild((CommandNode)arg);
        this.queue.push(this.current);
        this.current = arg;
        return this;
    }

    public CommandBuilder addLiteral(String name, Command<CommandSource> execute) {
        LiteralCommandNode arg = ((LiteralArgumentBuilder)Commands.func_197057_a((String)name).executes(execute)).build();
        this.current.addChild((CommandNode)arg);
        this.queue.push(this.current);
        this.current = arg;
        return this;
    }

    public CommandBuilder addArgument(String name, ArgumentType<?> type) {
        ArgumentCommandNode arg = Commands.func_197056_a((String)name, type).build();
        this.current.addChild((CommandNode)arg);
        this.queue.push(this.current);
        this.current = arg;
        return this;
    }

    public CommandBuilder addArgument(String name, ArgumentType<?> type, Command<CommandSource> execute) {
        ArgumentCommandNode arg = ((RequiredArgumentBuilder)Commands.func_197056_a((String)name, type).executes(execute)).build();
        this.current.addChild((CommandNode)arg);
        this.queue.push(this.current);
        this.current = arg;
        return this;
    }

    public CommandBuilder addArgument(ArgumentBuilder<CommandSource, ?> arg) {
        CommandNode com = arg.build();
        this.current.addChild(com);
        this.queue.push(this.current);
        this.current = com;
        return this;
    }

    public CommandBuilder popTop() {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        return this;
    }

    public CommandBuilder pop() {
        this.current = (CommandNode)this.queue.pop();
        return this;
    }

    public CommandBuilder pop(int layers) {
        while (layers > 0) {
            this.current = (CommandNode)this.queue.pop();
            --layers;
        }
        return this;
    }

    public CommandNode<CommandSource> build() {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        return this.current;
    }

    public List<String> build(List<String> list) {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        this.build(this.current, "", list, false);
        return list;
    }

    private void build(CommandNode<?> node, String current, List<String> result, boolean optional) {
        String s = current + "\n" + node.getName() + (optional ? " (Optional)" : "");
        if (node.getCommand() != null) {
            result.add(s);
        }
        for (CommandNode subNode : node.getChildren()) {
            this.build(subNode, s, result, optional || node.getCommand() != null);
        }
    }
}

