/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import pregenerator.ChunkPregenerator;

public class ReflectionHelper {
    public static <T, K> T getValueSave(Class<K> clz, K instance, int index) {
        try {
            Field field = clz.getDeclaredFields()[index];
            if (field != null) {
                field.setAccessible(true);
                return (T)field.get(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <K, T> T getValueSave(Class<K> clz, K instance, Class<T> targetClass) {
        try {
            Field[] fields = clz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!targetClass.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return (T)field.get(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T, K> T getValueSave(Class<K> clz, K instance, String ... names) {
        try {
            Field field = ReflectionHelper.findField(clz, names);
            if (field != null) {
                return (T)field.get(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T, K> T getValueSave(Class<K> clz, K instance, T defaultValue, String ... names) {
        try {
            Field field = ReflectionHelper.findField(clz, names);
            if (field != null) {
                return (T)field.get(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static <K> void setValueSave(Class<K> clz, K instance, Object value, String ... names) {
        try {
            Field field = ReflectionHelper.findField(clz, names);
            if (field != null) {
                field.set(instance, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T, K> void setSafeValue(Class<K> clz, K instance, T value, int index) {
        try {
            Field field = clz.getDeclaredFields()[index];
            if (field != null) {
                field.setAccessible(true);
                field.set(instance, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Method findMethod(Class<?> clazz, String[] methodNames, Class<?> ... parameterTypes) {
        for (String name : methodNames) {
            try {
                Method method = clazz.getDeclaredMethod(name, parameterTypes);
                if (method == null) continue;
                method.setAccessible(true);
                return method;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                if (f == null) continue;
                f.setAccessible(true);
                return f;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T, V> void setFinalValue(Class<? super T> clz, T instance, V value, String ... names) {
        try {
            Field field = ReflectionHelper.findField(clz, names);
            if (field != null) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(instance, value);
            }
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.info("Reflection Instance not found! Names" + ObjectArrayList.wrap((Object[])names));
            ChunkPregenerator.LOGGER.catching((Throwable)e);
        }
    }
}

