/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.handler.ControllerHandler;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.event.GunFireEvent;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageShoot;
import com.mrcrayfish.guns.network.message.MessageShooting;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class ShootingHandler {
    private static ShootingHandler instance;
    private boolean shooting;

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    private ShootingHandler() {
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_213279_p != null) {
            return false;
        }
        if (mc.field_71462_r != null) {
            return false;
        }
        if (!mc.field_71417_B.func_198035_h()) {
            return false;
        }
        return mc.func_195544_aj();
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.RawMouseEvent event) {
        if (!this.isInGame()) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (event.getButton() == 1 && AimingHandler.get().isLookingAtInteractableBlock()) {
            if (player.func_184614_ca().func_77973_b() instanceof GunItem && !AimingHandler.get().isLookingAtInteractableBlock()) {
                event.setCanceled(true);
            }
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            int button = event.getButton();
            if (button == 0 || button == 1) {
                event.setCanceled(true);
            }
            if (event.getAction() == 1 && button == 0) {
                this.fire((PlayerEntity)player, heldItem);
            }
        }
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null) {
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_77973_b() instanceof GunItem && (Gun.hasAmmo(heldItem) || player.func_184812_l_())) {
                boolean shooting;
                boolean bl = shooting = GLFW.glfwGetMouseButton((long)mc.func_228018_at_().func_198092_i(), (int)0) == 1;
                if (GunMod.controllableLoaded) {
                    shooting |= ControllerHandler.isShooting();
                }
                if (shooting) {
                    if (!this.shooting) {
                        this.shooting = true;
                        PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(true));
                    }
                } else if (this.shooting) {
                    this.shooting = false;
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(false));
                }
            } else if (this.shooting) {
                this.shooting = false;
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(false));
            }
        } else {
            this.shooting = false;
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        Gun gun;
        ItemStack heldItem;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof GunItem && GLFW.glfwGetMouseButton((long)mc.func_228018_at_().func_198092_i(), (int)0) == 1 && (gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem)).getGeneral().isAuto()) {
            this.fire((PlayerEntity)player, heldItem);
        }
    }

    public void fire(PlayerEntity player, ItemStack heldItem) {
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem) && !player.func_184812_l_()) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        CooldownTracker tracker = player.func_184811_cZ();
        if (!tracker.func_185141_a(heldItem.func_77973_b())) {
            GunItem gunItem = (GunItem)heldItem.func_77973_b();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(player, heldItem))) {
                return;
            }
            int rate = GunEnchantmentHelper.getRate(heldItem, modifiedGun);
            rate = GunModifierHelper.getModifiedRate(heldItem, rate);
            tracker.func_185145_a(heldItem.func_77973_b(), rate);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageShoot(player));
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
        }
    }
}

