/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mrcrayfish.guns.annotation.Ignored;
import com.mrcrayfish.guns.annotation.Optional;
import com.mrcrayfish.guns.common.GripType;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.item.attachment.IScope;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public final class Gun
implements INBTSerializable<CompoundNBT> {
    private General general = new General();
    private Projectile projectile = new Projectile();
    private Sounds sounds = new Sounds();
    private Display display = new Display();
    private Modules modules = new Modules();

    public General getGeneral() {
        return this.general;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("General", (INBT)this.general.serializeNBT());
        tag.func_218657_a("Projectile", (INBT)this.projectile.serializeNBT());
        tag.func_218657_a("Sounds", (INBT)this.sounds.serializeNBT());
        tag.func_218657_a("Display", (INBT)this.display.serializeNBT());
        tag.func_218657_a("Modules", (INBT)this.modules.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_150297_b("General", 10)) {
            this.general.deserializeNBT(tag.func_74775_l("General"));
        }
        if (tag.func_150297_b("Projectile", 10)) {
            this.projectile.deserializeNBT(tag.func_74775_l("Projectile"));
        }
        if (tag.func_150297_b("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.func_74775_l("Sounds"));
        }
        if (tag.func_150297_b("Display", 10)) {
            this.display.deserializeNBT(tag.func_74775_l("Display"));
        }
        if (tag.func_150297_b("Modules", 10)) {
            this.modules.deserializeNBT(tag.func_74775_l("Modules"));
        }
    }

    public static Gun create(CompoundNBT tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean canAttachType(@Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null;
                }
                case STOCK: {
                    return this.modules.attachments.stock != null;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel != null;
                }
            }
        }
        return false;
    }

    @Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope;
                }
                case BARREL: {
                    return this.modules.attachments.barrel;
                }
                case STOCK: {
                    return this.modules.attachments.stock;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel;
                }
            }
        }
        return null;
    }

    public boolean canAimDownSight() {
        return this.canAttachType(IAttachment.Type.SCOPE) || this.modules.zoom != null;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        CompoundNBT attachment;
        CompoundNBT compound = gun.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10) && (attachment = compound.func_74775_l("Attachments")).func_150297_b("Scope", 10)) {
            return ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l("Scope"));
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, IAttachment.Type type) {
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10)) {
            CompoundNBT attachment = compound.func_74775_l("Attachments");
            return attachment.func_150297_b(type.getTagKey(), 10);
        }
        return false;
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        CompoundNBT attachment;
        CompoundNBT compound = gun.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10) && (attachment = compound.func_74775_l("Attachments")).func_150297_b("Scope", 10)) {
            ItemStack scopeStack = ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l("Scope"));
            Scope scope = null;
            if (scopeStack.func_77973_b() instanceof IScope) {
                scope = (Scope)((IScope)scopeStack.func_77973_b()).getProperties();
            }
            return scope;
        }
        return null;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        CompoundNBT attachment;
        CompoundNBT compound = gun.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10) && (attachment = compound.func_74775_l("Attachments")).func_150297_b(type.getTagKey(), 10)) {
            return ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l(type.getTagKey()));
        }
        return ItemStack.field_190927_a;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundNBT tag = gunStack.func_196082_o();
        return tag.func_74760_g("AdditionalDamage");
    }

    public static ItemStack findAmmo(PlayerEntity player, ResourceLocation id) {
        if (player.func_184812_l_()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            return item != null ? new ItemStack((IItemProvider)item, Integer.MAX_VALUE) : ItemStack.field_190927_a;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && stack.func_77973_b().getRegistryName().equals((Object)id);
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundNBT tag = gunStack.func_196082_o();
        return tag.func_74767_n("IgnoreAmmo") || tag.func_74762_e("AmmoCount") > 0;
    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        protected double scale = 1.0;

        public ScaledPositioned() {
        }

        public ScaledPositioned(CompoundNBT tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT tag = super.serializeNBT();
            tag.func_74780_a("Scale", this.scale);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundNBT tag) {
            super.deserializeNBT(tag);
            if (tag.func_150297_b("Scale", 99)) {
                this.scale = tag.func_74769_h("Scale");
            }
        }

        public double getScale() {
            return this.scale;
        }

        @Override
        public ScaledPositioned copy() {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            return positioned;
        }
    }

    public static class Positioned
    implements INBTSerializable<CompoundNBT> {
        @Optional
        protected double xOffset;
        @Optional
        protected double yOffset;
        @Optional
        protected double zOffset;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74780_a("XOffset", this.xOffset);
            tag.func_74780_a("YOffset", this.yOffset);
            tag.func_74780_a("ZOffset", this.zOffset);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("XOffset", 99)) {
                this.xOffset = tag.func_74769_h("XOffset");
            }
            if (tag.func_150297_b("YOffset", 99)) {
                this.yOffset = tag.func_74769_h("YOffset");
            }
            if (tag.func_150297_b("ZOffset", 99)) {
                this.zOffset = tag.func_74769_h("ZOffset");
            }
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }

        public double getZOffset() {
            return this.zOffset;
        }

        public Positioned copy() {
            Positioned positioned = new Positioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            return positioned;
        }
    }

    public static class Modules
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        private Zoom zoom;
        private Attachments attachments = new Attachments();

        @Nullable
        public Zoom getZoom() {
            return this.zoom;
        }

        public Attachments getAttachments() {
            return this.attachments;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.zoom != null) {
                tag.func_218657_a("Zoom", (INBT)this.zoom.serializeNBT());
            }
            tag.func_218657_a("Attachments", (INBT)this.attachments.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Zoom", 10)) {
                Zoom zoom = new Zoom();
                zoom.deserializeNBT(tag.func_74775_l("Zoom"));
                this.zoom = zoom;
            }
            if (tag.func_150297_b("Attachments", 10)) {
                this.attachments.deserializeNBT(tag.func_74775_l("Attachments"));
            }
        }

        public Modules copy() {
            Modules modules = new Modules();
            if (this.zoom != null) {
                modules.zoom = this.zoom.copy();
            }
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Attachments
        implements INBTSerializable<CompoundNBT> {
            @Optional
            @Nullable
            private ScaledPositioned scope;
            @Optional
            @Nullable
            private ScaledPositioned barrel;
            @Optional
            @Nullable
            private ScaledPositioned stock;
            @Optional
            @Nullable
            private ScaledPositioned underBarrel;

            @Nullable
            public ScaledPositioned getScope() {
                return this.scope;
            }

            @Nullable
            public ScaledPositioned getBarrel() {
                return this.barrel;
            }

            @Nullable
            public ScaledPositioned getStock() {
                return this.stock;
            }

            @Nullable
            public ScaledPositioned getUnderBarrel() {
                return this.underBarrel;
            }

            public CompoundNBT serializeNBT() {
                CompoundNBT tag = new CompoundNBT();
                if (this.scope != null) {
                    tag.func_218657_a("Scope", (INBT)this.scope.serializeNBT());
                }
                if (this.barrel != null) {
                    tag.func_218657_a("Barrel", (INBT)this.barrel.serializeNBT());
                }
                if (this.stock != null) {
                    tag.func_218657_a("Stock", (INBT)this.stock.serializeNBT());
                }
                if (this.underBarrel != null) {
                    tag.func_218657_a("UnderBarrel", (INBT)this.underBarrel.serializeNBT());
                }
                return tag;
            }

            public void deserializeNBT(CompoundNBT tag) {
                if (tag.func_150297_b("Scope", 10)) {
                    this.scope = this.createScaledPositioned(tag, "Scope");
                }
                if (tag.func_150297_b("Barrel", 10)) {
                    this.barrel = this.createScaledPositioned(tag, "Barrel");
                }
                if (tag.func_150297_b("Stock", 10)) {
                    this.stock = this.createScaledPositioned(tag, "Stock");
                }
                if (tag.func_150297_b("UnderBarrel", 10)) {
                    this.underBarrel = this.createScaledPositioned(tag, "UnderBarrel");
                }
            }

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                if (this.stock != null) {
                    attachments.stock = this.stock.copy();
                }
                if (this.underBarrel != null) {
                    attachments.underBarrel = this.underBarrel.copy();
                }
                return attachments;
            }

            @Nullable
            private ScaledPositioned createScaledPositioned(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new ScaledPositioned(attachment);
            }
        }

        public static class Zoom
        extends Positioned {
            @Optional
            private float fovModifier;

            @Override
            public CompoundNBT serializeNBT() {
                CompoundNBT tag = super.serializeNBT();
                tag.func_74776_a("FovModifier", this.fovModifier);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundNBT tag) {
                super.deserializeNBT(tag);
                if (tag.func_150297_b("FovModifier", 99)) {
                    this.fovModifier = tag.func_74760_g("FovModifier");
                }
            }

            @Override
            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }

            public float getFovModifier() {
                return this.fovModifier;
            }
        }
    }

    public static class Display
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        private Flash flash;

        @Nullable
        public Flash getFlash() {
            return this.flash;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.flash != null) {
                tag.func_218657_a("Flash", (INBT)this.flash.serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Flash", 10)) {
                CompoundNBT flashTag = tag.func_74775_l("Flash");
                if (!flashTag.isEmpty()) {
                    Flash flash = new Flash();
                    flash.deserializeNBT(tag.func_74775_l("Flash"));
                    this.flash = flash;
                } else {
                    this.flash = null;
                }
            }
        }

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            return display;
        }

        public static class Flash
        extends Positioned {
            private double size = 0.5;

            @Override
            public CompoundNBT serializeNBT() {
                CompoundNBT tag = super.serializeNBT();
                tag.func_74780_a("Size", this.size);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundNBT tag) {
                super.deserializeNBT(tag);
                if (tag.func_150297_b("Size", 99)) {
                    this.size = tag.func_74769_h("Size");
                }
            }

            @Override
            public Flash copy() {
                Flash flash = new Flash();
                flash.size = this.size;
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                return flash;
            }

            public double getSize() {
                return this.size;
            }
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        private ResourceLocation fire;
        @Optional
        @Nullable
        private ResourceLocation reload;
        @Optional
        @Nullable
        private ResourceLocation cock;
        @Optional
        @Nullable
        private ResourceLocation silencedFire;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.fire != null) {
                tag.func_74778_a("Fire", this.fire.toString());
            }
            if (this.reload != null) {
                tag.func_74778_a("Reload", this.reload.toString());
            }
            if (this.cock != null) {
                tag.func_74778_a("Cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                tag.func_74778_a("SilencedFire", this.silencedFire.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Fire", 8)) {
                this.fire = this.createSound(tag, "Fire");
            }
            if (tag.func_150297_b("Reload", 8)) {
                this.reload = this.createSound(tag, "Reload");
            }
            if (tag.func_150297_b("Cock", 8)) {
                this.cock = this.createSound(tag, "Cock");
            }
            if (tag.func_150297_b("SilencedFire", 8)) {
                this.silencedFire = this.createSound(tag, "SilencedFire");
            }
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.silencedFire = this.silencedFire;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundNBT tag, String key) {
            String sound = tag.func_74779_i(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getFire() {
            return this.fire;
        }

        @Nullable
        public ResourceLocation getReload() {
            return this.reload;
        }

        @Nullable
        public ResourceLocation getCock() {
            return this.cock;
        }

        @Nullable
        public ResourceLocation getSilencedFire() {
            return this.silencedFire;
        }
    }

    public static class Projectile
    implements INBTSerializable<CompoundNBT> {
        private ResourceLocation item = new ResourceLocation("cgm", "basic_ammo");
        @Optional
        private boolean visible;
        private float damage;
        private float size;
        private double speed;
        private int life;
        @Optional
        private boolean gravity;
        @Optional
        private boolean damageReduceOverLife;
        @Optional
        private int trailColor = 16765577;
        @Optional
        private double trailLengthMultiplier = 1.0;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("Item", this.item.toString());
            tag.func_74757_a("Visible", this.visible);
            tag.func_74776_a("Damage", this.damage);
            tag.func_74776_a("Size", this.size);
            tag.func_74780_a("Speed", this.speed);
            tag.func_74768_a("Life", this.life);
            tag.func_74757_a("Gravity", this.gravity);
            tag.func_74757_a("DamageReduceOverLife", this.damageReduceOverLife);
            tag.func_74768_a("TrailColor", this.trailColor);
            tag.func_74780_a("TrailLengthMultiplier", this.trailLengthMultiplier);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Item", 8)) {
                this.item = new ResourceLocation(tag.func_74779_i("Item"));
            }
            if (tag.func_150297_b("Visible", 99)) {
                this.visible = tag.func_74767_n("Visible");
            }
            if (tag.func_150297_b("Damage", 99)) {
                this.damage = tag.func_74760_g("Damage");
            }
            if (tag.func_150297_b("Size", 99)) {
                this.size = tag.func_74760_g("Size");
            }
            if (tag.func_150297_b("Speed", 99)) {
                this.speed = tag.func_74769_h("Speed");
            }
            if (tag.func_150297_b("Life", 99)) {
                this.life = tag.func_74762_e("Life");
            }
            if (tag.func_150297_b("Gravity", 99)) {
                this.gravity = tag.func_74767_n("Gravity");
            }
            if (tag.func_150297_b("DamageReduceOverLife", 99)) {
                this.damageReduceOverLife = tag.func_74767_n("DamageReduceOverLife");
            }
            if (tag.func_150297_b("TrailColor", 99)) {
                this.trailColor = tag.func_74762_e("TrailColor");
            }
            if (tag.func_150297_b("TrailLengthMultiplier", 99)) {
                this.trailLengthMultiplier = tag.func_74769_h("TrailLengthMultiplier");
            }
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.visible = this.visible;
            projectile.damage = this.damage;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            return projectile;
        }

        public ResourceLocation getItem() {
            return this.item;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public float getDamage() {
            return this.damage;
        }

        public float getSize() {
            return this.size;
        }

        public double getSpeed() {
            return this.speed;
        }

        public int getLife() {
            return this.life;
        }

        public boolean isGravity() {
            return this.gravity;
        }

        public boolean isDamageReduceOverLife() {
            return this.damageReduceOverLife;
        }

        public int getTrailColor() {
            return this.trailColor;
        }

        public double getTrailLengthMultiplier() {
            return this.trailLengthMultiplier;
        }
    }

    public static class General
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private boolean auto = false;
        private int rate;
        @Ignored
        private GripType gripType = GripType.ONE_HANDED;
        private int maxAmmo;
        @Optional
        private int reloadAmount = 1;
        @Optional
        private float recoilAngle;
        @Optional
        private float recoilKick;
        @Optional
        private float recoilDurationOffset;
        @Optional
        private float recoilAdsReduction = 0.2f;
        @Optional
        private int projectileAmount = 1;
        @Optional
        private boolean alwaysSpread;
        @Optional
        private float spread;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Auto", this.auto);
            tag.func_74768_a("Rate", this.rate);
            tag.func_74778_a("GripType", this.gripType.getId().toString());
            tag.func_74768_a("MaxAmmo", this.maxAmmo);
            tag.func_74768_a("ReloadSpeed", this.reloadAmount);
            tag.func_74776_a("RecoilAngle", this.recoilAngle);
            tag.func_74776_a("RecoilKick", this.recoilKick);
            tag.func_74776_a("RecoilDurationOffset", this.recoilDurationOffset);
            tag.func_74776_a("RecoilAdsReduction", this.recoilAdsReduction);
            tag.func_74768_a("ProjectileAmount", this.projectileAmount);
            tag.func_74757_a("AlwaysSpread", this.alwaysSpread);
            tag.func_74776_a("Spread", this.spread);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Auto", 99)) {
                this.auto = tag.func_74767_n("Auto");
            }
            if (tag.func_150297_b("Rate", 99)) {
                this.rate = tag.func_74762_e("Rate");
            }
            if (tag.func_150297_b("GripType", 8)) {
                this.gripType = GripType.getType(ResourceLocation.func_208304_a((String)tag.func_74779_i("GripType")));
            }
            if (tag.func_150297_b("MaxAmmo", 99)) {
                this.maxAmmo = tag.func_74762_e("MaxAmmo");
            }
            if (tag.func_150297_b("ReloadSpeed", 99)) {
                this.reloadAmount = tag.func_74762_e("ReloadSpeed");
            }
            if (tag.func_150297_b("RecoilAngle", 99)) {
                this.recoilAngle = tag.func_74760_g("RecoilAngle");
            }
            if (tag.func_150297_b("RecoilKick", 99)) {
                this.recoilKick = tag.func_74760_g("RecoilKick");
            }
            if (tag.func_150297_b("RecoilDurationOffset", 99)) {
                this.recoilDurationOffset = tag.func_74760_g("RecoilDurationOffset");
            }
            if (tag.func_150297_b("RecoilAdsReduction", 99)) {
                this.recoilAdsReduction = tag.func_74760_g("RecoilAdsReduction");
            }
            if (tag.func_150297_b("ProjectileAmount", 99)) {
                this.projectileAmount = tag.func_74762_e("ProjectileAmount");
            }
            if (tag.func_150297_b("AlwaysSpread", 99)) {
                this.alwaysSpread = tag.func_74767_n("AlwaysSpread");
            }
            if (tag.func_150297_b("Spread", 99)) {
                this.spread = tag.func_74760_g("Spread");
            }
        }

        public General copy() {
            General general = new General();
            general.auto = this.auto;
            general.rate = this.rate;
            general.gripType = this.gripType;
            general.maxAmmo = this.maxAmmo;
            general.reloadAmount = this.reloadAmount;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.recoilDurationOffset = this.recoilDurationOffset;
            general.recoilAdsReduction = this.recoilAdsReduction;
            general.projectileAmount = this.projectileAmount;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            return general;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public int getRate() {
            return this.rate;
        }

        public GripType getGripType() {
            return this.gripType;
        }

        public int getMaxAmmo() {
            return this.maxAmmo;
        }

        public int getReloadAmount() {
            return this.reloadAmount;
        }

        public float getRecoilAngle() {
            return this.recoilAngle;
        }

        public float getRecoilKick() {
            return this.recoilKick;
        }

        public float getRecoilDurationOffset() {
            return this.recoilDurationOffset;
        }

        public float getRecoilAdsReduction() {
            return this.recoilAdsReduction;
        }

        public int getProjectileAmount() {
            return this.projectileAmount;
        }

        public boolean isAlwaysSpread() {
            return this.alwaysSpread;
        }

        public float getSpread() {
            return this.spread;
        }
    }
}

