/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item;

import java.util.List;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IColored {
    default public boolean canColor(ItemStack stack) {
        return true;
    }

    default public boolean hasColor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        return tagCompound.func_150297_b("Color", 3);
    }

    default public int getColor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        return tagCompound.func_74762_e("Color");
    }

    default public void setColor(ItemStack stack, int color) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_74768_a("Color", color);
    }

    default public void removeColor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_82580_o("Color");
    }

    public static ItemStack dye(ItemStack stack, List<DyeItem> dyes) {
        ItemStack resultStack = ItemStack.field_190927_a;
        int[] combinedColors = new int[3];
        int maxColor = 0;
        int colorCount = 0;
        IColored coloredItem = null;
        if (stack.func_77973_b() instanceof IColored && ((IColored)stack.func_77973_b()).canColor(stack)) {
            coloredItem = (IColored)stack.func_77973_b();
            resultStack = stack.func_77946_l();
            resultStack.func_190920_e(1);
            if (coloredItem.hasColor(stack)) {
                int color = coloredItem.getColor(resultStack);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                maxColor = (int)((float)maxColor + Math.max(red, Math.max(green, blue)) * 255.0f);
                combinedColors[0] = (int)((float)combinedColors[0] + red * 255.0f);
                combinedColors[1] = (int)((float)combinedColors[1] + green * 255.0f);
                combinedColors[2] = (int)((float)combinedColors[2] + blue * 255.0f);
                ++colorCount;
            }
            for (DyeItem dyeitem : dyes) {
                float[] colorComponents = dyeitem.func_195962_g().func_193349_f();
                int red = (int)(colorComponents[0] * 255.0f);
                int green = (int)(colorComponents[1] * 255.0f);
                int blue = (int)(colorComponents[2] * 255.0f);
                maxColor += Math.max(red, Math.max(green, blue));
                combinedColors[0] = combinedColors[0] + red;
                combinedColors[1] = combinedColors[1] + green;
                combinedColors[2] = combinedColors[2] + blue;
                ++colorCount;
            }
        }
        if (coloredItem == null) {
            return ItemStack.field_190927_a;
        }
        int red = combinedColors[0] / colorCount;
        int green = combinedColors[1] / colorCount;
        int blue = combinedColors[2] / colorCount;
        float averageColor = (float)maxColor / (float)colorCount;
        float maxValue = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageColor / maxValue);
        green = (int)((float)green * averageColor / maxValue);
        blue = (int)((float)blue * averageColor / maxValue);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        coloredItem.setColor(resultStack, finalColor);
        return resultStack;
    }
}

