/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.core.handler.lootmodifier;

import com.google.gson.JsonObject;
import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.items.alfsteel.ItemAlfsteelAIOT;
import de.melanx.aiotbotania.items.terrasteel.ItemTerraSteelAIOT;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import vazkii.botania.common.lib.ModTags;

public class DisposeModifier
extends LootModifier {
    protected DisposeModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    public static void filterDisposable(List<ItemStack> drops, Entity entity, ItemStack stack) {
        if (!stack.func_190926_b() && (stack.func_77973_b() == Registration.elementium_aiot.get() || stack.func_77973_b() == Registration.terrasteel_aiot.get() && ItemTerraSteelAIOT.isTipped(stack) || stack.func_77973_b() == Registration.alfsteel_aiot.get() && ItemAlfsteelAIOT.isTipped(stack))) {
            drops.removeIf(s -> !s.func_190926_b() && (DisposeModifier.isDisposable(s) || DisposeModifier.isSemiDisposable(s) && !entity.func_213453_ef()));
        }
    }

    private static boolean isDisposable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return ModTags.Items.DISPOSABLE.func_230235_a_((Object)stack.func_77973_b());
    }

    private static boolean isSemiDisposable(ItemStack stack) {
        return ModTags.Items.SEMI_DISPOSABLE.func_230235_a_((Object)stack.func_77973_b());
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (entity != null && tool != null && !tool.func_190926_b()) {
            DisposeModifier.filterDisposable(generatedLoot, entity, tool);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DisposeModifier> {
        public DisposeModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new DisposeModifier(conditions);
        }

        public JsonObject write(DisposeModifier instance) {
            return null;
        }
    }
}

