/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.core.proxy;

import com.google.common.collect.ImmutableMap;
import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.core.config.ConfigHandler;
import de.melanx.aiotbotania.core.network.AIOTBotaniaNetwork;
import de.melanx.aiotbotania.core.proxy.IProxy;
import de.melanx.aiotbotania.items.alfsteel.CustomPylonRepairable;
import de.melanx.aiotbotania.items.alfsteel.RecipeAlfsteelAIOT;
import de.melanx.aiotbotania.items.alfsteel.RecipeAlfsteelAIOTTipped;
import de.melanx.aiotbotania.items.terrasteel.RecipeTerraSteelAIOT;
import de.melanx.aiotbotania.items.terrasteel.RecipeTerraSteelAIOTTipped;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.common.item.ModItems;

public class CommonProxy
implements IProxy {
    public static final ResourceLocation TERRA_RECIPE_ID = new ResourceLocation("aiotbotania", "recipe_terrasteel_aiot");
    public static final ResourceLocation TERRA_RECIPE_ID_TIPPED = new ResourceLocation("aiotbotania", "recipe_terrasteel_aiot_tipped");
    public static final ResourceLocation ALFSTEEL_RECIPE_ID = new ResourceLocation("aiotbotania", "recipe_alfsteel_aiot");
    public static final ResourceLocation ALFSTEEL_RECIPE_ID_TIPPED = new ResourceLocation("aiotbotania", "recipe_alfsteel_aiot_tipped");

    public CommonProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onReload);
        MinecraftForge.EVENT_BUS.addListener(this::onTilt);
    }

    public void setup(FMLCommonSetupEvent event) {
        AIOTBotaniaNetwork.registerPackets();
        if (ModList.get().isLoaded("mythicbotany")) {
            CustomPylonRepairable.pylonRepairable().run();
        }
        Registration.registerDispenseBehavior();
    }

    public void onReload(final AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ReloadListener<Object>(){

            @Nonnull
            protected Object func_212854_a_(@Nonnull IResourceManager manager, @Nonnull IProfiler profiler) {
                return new Object();
            }

            protected void func_212853_a_(@Nonnull Object unused, @Nonnull IResourceManager manager, @Nonnull IProfiler profiler) {
                if (((Boolean)ConfigHandler.COMMON.TERRA_AIOT.get()).booleanValue() || ModList.get().isLoaded("mythicbotany")) {
                    RecipeManager rm = event.getDataPackRegistries().func_240967_e_();
                    Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)rm, (String)"field_199522_d");
                    Map recipesNew = (Map)recipes.entrySet().stream().map(entry -> {
                        if (entry.getKey() == IRecipeType.field_222149_a) {
                            return Pair.of(entry.getKey(), this.insertRecipe((Map)entry.getValue()));
                        }
                        return entry;
                    }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                    ObfuscationReflectionHelper.setPrivateValue(RecipeManager.class, (Object)rm, (Object)recipesNew, (String)"field_199522_d");
                }
            }

            private Map<ResourceLocation, IRecipe<?>> insertRecipe(Map<ResourceLocation, IRecipe<?>> recipeMap) {
                ImmutableMap.Builder builder = ImmutableMap.builder().putAll(recipeMap);
                if (((Boolean)ConfigHandler.COMMON.TERRA_AIOT.get()).booleanValue()) {
                    builder.put((Object)TERRA_RECIPE_ID, (Object)new RecipeTerraSteelAIOT(TERRA_RECIPE_ID, "terrasteel_aiot")).put((Object)TERRA_RECIPE_ID_TIPPED, (Object)new RecipeTerraSteelAIOTTipped(TERRA_RECIPE_ID_TIPPED, "recipe_terrasteel_aiot_tipped"));
                }
                if (ModList.get().isLoaded("mythicbotany")) {
                    builder.put((Object)ALFSTEEL_RECIPE_ID, (Object)new RecipeAlfsteelAIOT(ALFSTEEL_RECIPE_ID, "recipe_alfsteel_aiot")).put((Object)ALFSTEEL_RECIPE_ID_TIPPED, (Object)new RecipeAlfsteelAIOTTipped(ALFSTEEL_RECIPE_ID_TIPPED, "recipe_alfsteel_aiot_tipped"));
                }
                return builder.build();
            }
        });
    }

    public void onTilt(UseHoeEvent event) {
        ActionResultType resultType;
        ItemUseContext context = event.getContext();
        if (context.func_195991_k().field_72995_K) {
            return;
        }
        ItemStack stack = context.func_195996_i();
        if ((stack.func_77973_b() == ModItems.elementiumHoe || stack.func_77973_b() == ModItems.manasteelHoe) && (resultType = ToolUtil.hoeUse(context, stack.func_77973_b() == ModItems.elementiumHoe, false)) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }
}

