/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.elementium;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.base.ItemAIOTBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemElementiumAIOT
extends ItemAIOTBase {
    private static final int MANA_PER_DAMAGE = 66;
    private static final float DAMAGE = 6.0f;
    private static final float SPEED = -2.2f;

    public ItemElementiumAIOT() {
        super(ItemTiers.ELEMENTIUM_AIOT_ITEM_TIER, 6.0f, -2.2f, 66, true);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDrops);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y.func_77557_a(ModItems.elementiumSword);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap ret = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlotType)slot, (String)"AIOT modifier", (double)0.1));
        }
        return ret;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!ToolCommons.materialsShovel.contains(mat)) {
            return false;
        }
        Block blk = world.func_180495_p(pos).func_177230_c();
        if (blk instanceof FallingBlock) {
            ToolCommons.removeBlocksInIteration((PlayerEntity)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vector3i)new Vector3i(0, -12, 0), (Vector3i)new Vector3i(1, 12, 1), state -> state.func_177230_c() == blk);
        }
        return false;
    }

    private void onEntityDrops(LivingDropsEvent e) {
        ItemStack weapon;
        if (e.isRecentlyHit() && e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof PlayerEntity && !(weapon = ((PlayerEntity)e.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && weapon.func_77973_b() == this) {
            Random rand = e.getEntityLiving().field_70170_p.field_73012_v;
            int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)weapon);
            if (e.getEntityLiving() instanceof AbstractSkeletonEntity && rand.nextInt(26) <= 3 + looting) {
                this.addDrop(e, new ItemStack((IItemProvider)(e.getEntity() instanceof WitherSkeletonEntity ? Items.field_196183_dw : Items.field_196182_dv)));
            } else if (e.getEntityLiving() instanceof ZombieEntity && !(e.getEntityLiving() instanceof ZombifiedPiglinEntity) && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(e, new ItemStack((IItemProvider)Items.field_196186_dz));
            } else if (e.getEntityLiving() instanceof CreeperEntity && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(e, new ItemStack((IItemProvider)Items.field_196185_dy));
            } else if (e.getEntityLiving() instanceof PlayerEntity && rand.nextInt(11) <= 1 + looting) {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx);
                ItemNBTHelper.setString((ItemStack)stack, (String)"SkullOwner", (String)((PlayerEntity)e.getEntityLiving()).func_146103_bH().getName());
                this.addDrop(e, stack);
            } else if (e.getEntityLiving() instanceof EntityDoppleganger && rand.nextInt(13) < 1 + looting) {
                this.addDrop(e, new ItemStack((IItemProvider)ModBlocks.gaiaHead));
            }
        }
    }

    private void addDrop(LivingDropsEvent e, ItemStack drop) {
        ItemEntity entityitem = new ItemEntity(e.getEntityLiving().field_70170_p, e.getEntityLiving().field_70142_S, e.getEntityLiving().field_70137_T, e.getEntityLiving().field_70136_U, drop);
        entityitem.func_174867_a(10);
        e.getDrops().add(entityitem);
    }
}

