/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.util;

import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.items.livingrock.ItemLivingrockAIOT;
import de.melanx.aiotbotania.util.ToolBreakContext;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ToolUtil {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");

    public static void inventoryTick(ItemStack stack, World world, Entity player, int MPD) {
        if (!world.field_72995_K && player instanceof PlayerEntity && stack.func_77952_i() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (PlayerEntity)player, MPD * 2, true)) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    public static void toggleMode(PlayerEntity player, ItemStack stack) {
        Style dark_blue = Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_BLUE).func_240722_b_(Boolean.valueOf(true));
        Style aqua = Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA).func_240722_b_(Boolean.valueOf(true));
        IFormattableTextComponent text = new TranslationTextComponent("aiotbotania.toggleMode").func_240702_b_(" ").func_240703_c_(dark_blue);
        IFormattableTextComponent utilityMode = new TranslationTextComponent("aiotbotania.utilityMode").func_240703_c_(aqua);
        IFormattableTextComponent hoeMode = new TranslationTextComponent("aiotbotania.hoeMode").func_240703_c_(aqua);
        IFormattableTextComponent hoeModePath = new TranslationTextComponent("aiotbotania.hoeModePath").func_240703_c_(aqua);
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true)) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)false);
            text.func_230529_a_((ITextComponent)utilityMode);
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
            if (stack.func_77973_b() instanceof ItemLivingrockAIOT) {
                text = text.func_230529_a_((ITextComponent)hoeMode);
            } else {
                text.func_230529_a_((ITextComponent)hoeModePath);
            }
        }
        player.func_146105_b((ITextComponent)text, true);
    }

    public static ActionResultType hoemodeUse(@Nonnull ItemUseContext ctx, PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (!player.func_213453_ef()) {
            return ToolUtil.hoeUse(ctx, false, true);
        }
        if (side != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a())) {
            return ToolUtil.shovelUse(ctx);
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType hoeUse(ItemUseContext ctx, boolean special, boolean low_tier) {
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        if (player == null || !player.func_175151_a(pos, side, stack)) {
            return ActionResultType.PASS;
        }
        if (ctx.func_196000_l() != Direction.DOWN && world.func_175623_d(pos.func_177984_a())) {
            BlockState blockstate = world.func_180495_p(pos).getToolModifiedState(world, pos, ctx.func_195999_j(), ctx.func_195996_i(), ToolType.HOE);
            if (blockstate != null) {
                if (blockstate.func_177230_c() == Blocks.field_150458_ak && special) {
                    blockstate = ((Block)Registration.custom_farmland.get()).func_176223_P();
                }
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, blockstate, 11);
                    ctx.func_195996_i().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(ctx.func_221531_n()));
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            if (world.func_180495_p(pos).func_177230_c() instanceof FarmlandBlock) {
                Block block = null;
                if (special) {
                    block = Blocks.field_196658_i;
                } else if (!low_tier) {
                    block = Blocks.field_150346_d;
                }
                if (block != null) {
                    world.func_175656_a(pos, block.func_176223_P());
                    if (world.func_180495_p(player.func_233580_cy_()).func_177230_c() == Registration.custom_farmland.get()) {
                        player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 0.0625, player.func_226281_cx_());
                    }
                    return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                }
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType hoeUseAOE(ItemUseContext ctx, boolean special, boolean low_tier, int radius) {
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        Direction side = ctx.func_196000_l();
        BlockPos basePos = ctx.func_195995_a().func_185334_h();
        if (player == null || !player.func_175151_a(basePos, side, stack)) {
            return ActionResultType.PASS;
        }
        BlockState baseStateResult = world.func_180495_p(basePos).getToolModifiedState(world, basePos, player, stack, ToolType.HOE);
        ActionResultType toReturn = ToolUtil.hoeUse(ctx, special, low_tier);
        if (toReturn.func_226246_a_()) {
            boolean soundPlayed = false;
            for (int xd = -radius; xd <= radius; ++xd) {
                for (int zd = -radius; zd <= radius; ++zd) {
                    BlockState blockstate;
                    if (xd == 0 && zd == 0) continue;
                    BlockPos pos = basePos.func_177982_a(xd, 0, zd);
                    if (ctx.func_196000_l() == Direction.DOWN || !world.func_175623_d(pos.func_177984_a()) || baseStateResult != (blockstate = world.func_180495_p(pos).getToolModifiedState(world, pos, player, stack, ToolType.HOE))) continue;
                    if (blockstate != null) {
                        if (blockstate.func_177230_c() == Blocks.field_150458_ak && special) {
                            blockstate = ((Block)Registration.custom_farmland.get()).func_176223_P();
                        }
                        if (!soundPlayed) {
                            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            soundPlayed = true;
                        }
                        if (world.field_72995_K) continue;
                        world.func_180501_a(pos, blockstate, 11);
                        ctx.func_195996_i().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(ctx.func_221531_n()));
                        continue;
                    }
                    if (!(world.func_180495_p(pos).func_177230_c() instanceof FarmlandBlock)) continue;
                    Block block = null;
                    if (special) {
                        block = Blocks.field_196658_i;
                    } else if (!low_tier) {
                        block = Blocks.field_150346_d;
                    }
                    if (block == null) continue;
                    world.func_175656_a(pos, block.func_176223_P());
                }
            }
        }
        return toReturn;
    }

    @Nonnull
    public static ActionResultType pickUse(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !TORCH_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
                ActionResultType did = PlayerHelper.substituteUse((ItemUseContext)ctx, (ItemStack)stackAt);
                if (did == ActionResultType.SUCCESS && !ctx.func_195991_k().func_201670_d()) {
                    ItemsRemainingRenderHandler.send((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_150478_aa), (Pattern)TORCH_PATTERN);
                }
                return did;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public static ActionResultType axeUse(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !SAPLING_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
                ActionResultType did = PlayerHelper.substituteUse((ItemUseContext)ctx, (ItemStack)stackAt);
                if (did == ActionResultType.SUCCESS && !ctx.func_195991_k().func_201670_d()) {
                    ItemsRemainingRenderHandler.send((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196674_t), (Pattern)SAPLING_PATTERN);
                }
                return did;
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType shovelUse(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        if (ctx.func_196000_l() != Direction.DOWN) {
            PlayerEntity player = ctx.func_195999_j();
            BlockState modifiedState = state.getToolModifiedState(world, pos, player, ctx.func_195996_i(), ToolType.SHOVEL);
            if (modifiedState != null && world.func_175623_d(pos.func_177984_a())) {
                world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (state.func_177230_c() instanceof CampfireBlock && ((Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                if (!world.func_201670_d()) {
                    world.func_217378_a(null, 1009, pos, 0);
                }
                CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)pos, (BlockState)state);
                modifiedState = (BlockState)state.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
            }
            if (modifiedState != null) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, modifiedState, 11);
                    if (player != null) {
                        ctx.func_195996_i().func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(ctx.func_221531_n()));
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType stripLog(ItemUseContext ctx) {
        BlockPos blockpos;
        World world = ctx.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = ctx.func_195995_a());
        BlockState block = blockstate.getToolModifiedState(world, blockpos, ctx.func_195999_j(), ctx.func_195996_i(), ToolType.AXE);
        if (block != null) {
            PlayerEntity playerentity = ctx.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, block, 11);
                if (playerentity != null) {
                    ctx.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(ctx.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static void removeBlocksInRange(ToolBreakContext context, Direction side, int range) {
        boolean doX = side.func_82601_c() == 0;
        boolean doY = side.func_96559_d() == 0;
        boolean doZ = side.func_82599_e() == 0;
        Vector3i beginDiff = new Vector3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vector3i endDiff = new Vector3i(doX ? range : 0, doY ? range * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration((PlayerEntity)context.getPlayer(), (ItemStack)context.getItem(), (World)context.getWorld(), (BlockPos)context.getPos(), (Vector3i)beginDiff, (Vector3i)endDiff, context::isEffectiveOn);
    }
}

