/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.tile;

import com.tfar.metalbarrels.block.MetalBarrelBlock;
import com.tfar.metalbarrels.util.MetalBarrelBlockEntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.data.BlockStateVariantBuilder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MetalBarrelBlockEntity
extends TileEntity
implements INamedContainerProvider,
INameable {
    protected final int width;
    protected final int height;
    protected final BlockStateVariantBuilder.ITriFunction<Integer, PlayerInventory, IWorldPosCallable, Container> containerFactory;
    protected ITextComponent customName;
    public final LazyOptional<IItemHandler> optional;
    public final ItemStackHandler handler;
    public int players = 0;

    public MetalBarrelBlockEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.width = ((MetalBarrelBlockEntityType)tileEntityType).width;
        this.height = ((MetalBarrelBlockEntityType)tileEntityType).height;
        this.containerFactory = ((MetalBarrelBlockEntityType)tileEntityType).containerFactory;
        this.handler = new ItemStackHandler(this.width * this.height){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MetalBarrelBlockEntity.this.func_70296_d();
            }
        };
        this.optional = LazyOptional.of(() -> this.handler);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT compound = this.handler.serializeNBT();
        tag.func_218657_a("inv", (INBT)compound);
        if (this.customName != null) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return super.func_189515_b(tag);
    }

    public void changeState(BlockState p_213963_1_, boolean p_213963_2_) {
        if (p_213963_1_.func_177230_c() instanceof MetalBarrelBlock) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)p_213963_1_.func_206870_a((Property)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(p_213963_2_)), 3);
        }
    }

    public void soundStuff(BlockState p_213965_1_, SoundEvent p_213965_2_) {
        if (!(p_213965_1_.func_177230_c() instanceof MetalBarrelBlock)) {
            return;
        }
        Vector3i lvt_3_1_ = ((Direction)p_213965_1_.func_177229_b((Property)BarrelBlock.field_220092_a)).func_176730_m();
        double lvt_4_1_ = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)lvt_3_1_.func_177958_n() / 2.0;
        double lvt_6_1_ = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)lvt_3_1_.func_177956_o() / 2.0;
        double lvt_8_1_ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)lvt_3_1_.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a(null, lvt_4_1_, lvt_6_1_, lvt_8_1_, p_213965_2_, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.deserializeNBT(invTag);
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("CustomName"));
        }
        super.func_230337_a_(state, tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.optional.cast() : super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.optional.invalidate();
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return (Container)this.containerFactory.apply((Object)id, (Object)inv, (Object)IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c));
    }
}

