/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.util;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;

public class NBTHelper {
    @Nonnull
    public static CompoundNBT getBlockStateNBTTag(BlockState state) {
        if (state.func_177230_c().getRegistryName() == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("registryName", state.func_177230_c().getRegistryName().toString());
        ListNBT properties = new ListNBT();
        for (Property property : state.func_235904_r_()) {
            CompoundNBT propTag = new CompoundNBT();
            try {
                propTag.func_74778_a("value", property.func_177702_a(state.func_177229_b(property)));
            }
            catch (Exception exc) {
                continue;
            }
            propTag.func_74778_a("property", property.func_177701_a());
            properties.add((Object)propTag);
        }
        tag.func_218657_a("properties", (INBT)properties);
        return tag;
    }

    @Nullable
    public static <T extends Comparable<T>> BlockState getBlockStateFromTag(CompoundNBT cmp, BlockState _default) {
        ResourceLocation key = new ResourceLocation(cmp.func_74779_i("registryName"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        if (block == null || block == Blocks.field_150350_a) {
            return _default;
        }
        BlockState state = block.func_176223_P();
        Collection properties = state.func_235904_r_();
        ListNBT list = cmp.func_150295_c("properties", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT propertyTag = list.func_150305_b(i);
            String valueStr = propertyTag.func_74779_i("value");
            String propertyStr = propertyTag.func_74779_i("property");
            Property match = NBTHelper.iterativeSearch(properties, prop -> prop.func_177701_a().equalsIgnoreCase(propertyStr));
            if (match == null) continue;
            try {
                Optional opt = match.func_185929_b(valueStr);
                if (!opt.isPresent()) continue;
                state = (BlockState)state.func_206870_a(match, (Comparable)opt.get());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return state;
    }

    @Nullable
    private static <T> T iterativeSearch(Collection<T> collection, Predicate<T> matchingFct) {
        for (T element : collection) {
            if (!matchingFct.test(element)) continue;
            return element;
        }
        return null;
    }

    public static void setAsSubTag(CompoundNBT compound, String tag, Consumer<CompoundNBT> applyFct) {
        CompoundNBT newTag = new CompoundNBT();
        applyFct.accept(newTag);
        compound.func_218657_a(tag, (INBT)newTag);
    }

    public static void writeBlockPosToNBT(BlockPos pos, CompoundNBT compound) {
        compound.func_74768_a("bposX", pos.func_177958_n());
        compound.func_74768_a("bposY", pos.func_177956_o());
        compound.func_74768_a("bposZ", pos.func_177952_p());
    }

    public static BlockPos readBlockPosFromNBT(CompoundNBT compound) {
        int x = compound.func_74762_e("bposX");
        int y = compound.func_74762_e("bposY");
        int z = compound.func_74762_e("bposZ");
        return new BlockPos(x, y, z);
    }
}

