/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.xmpp;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.metrics.Metrics;
import com.earth2me.essentials.metrics.MetricsWrapper;
import com.earth2me.essentials.xmpp.EssentialsXMPPPlayerListener;
import com.earth2me.essentials.xmpp.IEssentialsXMPP;
import com.earth2me.essentials.xmpp.UserManager;
import com.earth2me.essentials.xmpp.XMPPManager;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsXMPP
extends JavaPlugin
implements IEssentialsXMPP {
    private static EssentialsXMPP instance = null;
    private transient UserManager users;
    private transient XMPPManager xmpp;
    private transient IEssentials ess;
    private transient MetricsWrapper metrics = null;

    static IEssentialsXMPP getInstance() {
        return instance;
    }

    static void updatePresence() {
        EssentialsXMPP.instance.xmpp.updatePresence();
    }

    public void onEnable() {
        instance = this;
        PluginManager pluginManager = this.getServer().getPluginManager();
        this.ess = (IEssentials)pluginManager.getPlugin("Essentials");
        if (!this.getDescription().getVersion().equals(this.ess.getDescription().getVersion())) {
            this.getLogger().log(Level.WARNING, I18n.tl((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        if (!this.ess.isEnabled()) {
            this.setEnabled(false);
            return;
        }
        EssentialsXMPPPlayerListener playerListener = new EssentialsXMPPPlayerListener(this.ess);
        pluginManager.registerEvents((Listener)playerListener, (Plugin)this);
        this.users = new UserManager(this.getDataFolder());
        this.xmpp = new XMPPManager(this);
        this.ess.addReloadListener((IConf)this.users);
        this.ess.addReloadListener((IConf)this.xmpp);
        if (this.metrics == null) {
            this.metrics = new MetricsWrapper((Plugin)this, 3818, true);
            this.metrics.addCustomChart((Metrics.CustomChart)new Metrics.SimplePie("config-valid", () -> this.xmpp.isConfigValid() ? "yes" : "no"));
        }
    }

    public void onDisable() {
        if (this.xmpp != null) {
            this.xmpp.disconnect();
        }
        instance = null;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        this.metrics.markCommand(command.getName(), true);
        return this.ess.onCommandEssentials(sender, command, commandLabel, args, EssentialsXMPP.class.getClassLoader(), "com.earth2me.essentials.xmpp.Command", "essentials.", null);
    }

    @Override
    public void setAddress(Player user, String address) {
        String username = user.getName().toLowerCase(Locale.ENGLISH);
        EssentialsXMPP.instance.users.setAddress(username, address);
    }

    @Override
    public String getAddress(String name) {
        return EssentialsXMPP.instance.users.getAddress(name);
    }

    @Override
    public net.ess3.api.IUser getUserByAddress(String address) {
        String username = EssentialsXMPP.instance.users.getUserByAddress(address);
        return username == null ? null : this.ess.getUser(username);
    }

    @Override
    public boolean toggleSpy(Player user) {
        String username = user.getName().toLowerCase(Locale.ENGLISH);
        boolean spy = !EssentialsXMPP.instance.users.isSpy(username);
        EssentialsXMPP.instance.users.setSpy(username, spy);
        return spy;
    }

    @Override
    public String getAddress(Player user) {
        return EssentialsXMPP.instance.users.getAddress(user.getName());
    }

    @Override
    public boolean sendMessage(Player user, String message) {
        return EssentialsXMPP.instance.xmpp.sendMessage(EssentialsXMPP.instance.users.getAddress(user.getName()), message);
    }

    @Override
    public boolean sendMessage(String address, String message) {
        return EssentialsXMPP.instance.xmpp.sendMessage(address, message);
    }

    @Override
    public List<String> getSpyUsers() {
        return EssentialsXMPP.instance.users.getSpyUsers();
    }

    @Override
    public void broadcastMessage(net.ess3.api.IUser sender, String message, String xmppAddress) {
        this.ess.broadcastMessage((IUser)sender, message);
        try {
            for (String address : this.getSpyUsers()) {
                if (address.equalsIgnoreCase(xmppAddress)) continue;
                this.sendMessage(address, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public IEssentials getEss() {
        return this.ess;
    }
}

