/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.xmpp;

import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.xmpp.EssentialsXMPP;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

class EssentialsXMPPPlayerListener
implements Listener {
    private final transient IEssentials ess;

    EssentialsXMPPPlayerListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.ess, EssentialsXMPP::updatePresence);
        this.sendMessageToSpyUsers("Player " + user.getDisplayName() + " joined the game");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        this.sendMessageToSpyUsers(String.format(event.getFormat(), user.getDisplayName(), event.getMessage()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.ess, EssentialsXMPP::updatePresence);
        this.sendMessageToSpyUsers("Player " + user.getDisplayName() + " left the game");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageToSpyUsers(String message) {
        try {
            List<String> users;
            List<String> list = users = EssentialsXMPP.getInstance().getSpyUsers();
            synchronized (list) {
                for (String address : users) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.ess, () -> EssentialsXMPP.getInstance().sendMessage(address, message));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

