/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.xmpp;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UserManager
implements IConf {
    private static final String ADDRESS = "address";
    private static final String SPY = "spy";
    private final transient EssentialsConf users;
    private final transient List<String> spyusers = Collections.synchronizedList(new ArrayList());

    UserManager(File folder) {
        this.users = new EssentialsConf(new File(folder, "users.yml"));
        this.reloadConfig();
    }

    final boolean isSpy(String username) {
        return this.users.getBoolean(username.toLowerCase(Locale.ENGLISH) + "." + SPY, false);
    }

    void setSpy(String username, boolean spy) {
        this.setUser(username.toLowerCase(Locale.ENGLISH), this.getAddress(username), spy);
    }

    final String getAddress(String username) {
        return this.users.getString(username.toLowerCase(Locale.ENGLISH) + "." + ADDRESS, null);
    }

    final String getUserByAddress(String search) {
        Set usernames = this.users.getKeys(false);
        for (String username : usernames) {
            String address = this.users.getString(username + "." + ADDRESS, null);
            if (!search.equalsIgnoreCase(address)) continue;
            return username;
        }
        return null;
    }

    void setAddress(String username, String address) {
        this.setUser(username.toLowerCase(Locale.ENGLISH), address, this.isSpy(username));
    }

    List<String> getSpyUsers() {
        return this.spyusers;
    }

    private void setUser(String username, String address, boolean spy) {
        HashMap<String, Object> userdata = new HashMap<String, Object>();
        userdata.put(ADDRESS, address);
        userdata.put(SPY, spy);
        this.users.setProperty(username, userdata);
        this.users.save();
        this.reloadConfig();
    }

    public final void reloadConfig() {
        this.users.load();
        this.spyusers.clear();
        Set keys = this.users.getKeys(false);
        for (String key : keys) {
            String address;
            if (!this.isSpy(key) || (address = this.getAddress(key)) == null) continue;
            this.spyusers.add(address);
        }
    }
}

