/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.xmpp;

import com.earth2me.essentials.Console;
import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.xmpp.EssentialsXMPP;
import com.earth2me.essentials.xmpp.IEssentialsXMPP;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.ess3.api.IUser;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPManager
extends Handler
implements MessageListener,
ChatManagerListener,
IConf {
    private static final Logger logger = Logger.getLogger("EssentialsXMPP");
    private static final SimpleFormatter formatter = new SimpleFormatter();
    private final transient EssentialsConf config;
    private final transient Map<String, Chat> chats = Collections.synchronizedMap(new HashMap());
    private final transient Set<LogRecord> logrecords = Collections.synchronizedSet(new HashSet());
    private final transient IEssentialsXMPP parent;
    private transient XMPPConnection connection;
    private transient ChatManager chatManager;
    private transient List<String> logUsers;
    private transient Level logLevel;
    private transient boolean ignoreLagMessages = true;
    private transient Thread loggerThread;
    private transient boolean threadrunning = true;

    XMPPManager(IEssentialsXMPP parent) {
        this.parent = parent;
        this.config = new EssentialsConf(new File(parent.getDataFolder(), "config.yml"));
        this.config.setTemplateName("/config.yml", EssentialsXMPP.class);
        this.reloadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendMessage(String address, String message) {
        if (address != null && !address.isEmpty()) {
            try {
                Chat chat;
                this.startChat(address);
                Map<String, Chat> map = this.chats;
                synchronized (map) {
                    chat = this.chats.get(address);
                }
                if (chat != null) {
                    if (!this.connection.isConnected()) {
                        this.disconnect();
                        this.connect();
                    }
                    chat.sendMessage(FormatUtil.stripFormat((String)message));
                    return true;
                }
            }
            catch (XMPPException ex) {
                this.disableChat(address);
            }
        }
        return false;
    }

    @Override
    public void processMessage(Chat chat, Message msg) {
        if (msg.getType() != Message.Type.error && msg.getBody().length() > 0) {
            String message = msg.getBody();
            switch (message.charAt(0)) {
                case '@': {
                    this.sendPrivateMessage(chat, message);
                    break;
                }
                case '/': {
                    this.sendCommand(chat, message);
                    break;
                }
                default: {
                    IUser sender = this.parent.getUserByAddress(StringUtils.parseBareAddress(chat.getParticipant()));
                    this.parent.broadcastMessage(sender, "=" + sender.getBase().getDisplayName() + ": " + message, StringUtils.parseBareAddress(chat.getParticipant()));
                }
            }
        }
    }

    private boolean connect() {
        String server = this.config.getString("xmpp.server");
        if (server == null || server.equals("example.com")) {
            logger.log(Level.WARNING, I18n.tl((String)"xmppNotConfigured", (Object[])new Object[0]));
            return false;
        }
        int port = this.config.getInt("xmpp.port", 5222);
        String serviceName = this.config.getString("xmpp.servicename", server);
        String xmppuser = this.config.getString("xmpp.user");
        String password = this.config.getString("xmpp.password");
        boolean requireTLS = this.config.getBoolean("xmpp.require-server-tls", false);
        ConnectionConfiguration connConf = new ConnectionConfiguration(server, port, serviceName);
        String stringBuilder = "Connecting to xmpp server " + server + ":" + port + " as user " + xmppuser + ".";
        logger.log(Level.INFO, stringBuilder);
        connConf.setSASLAuthenticationEnabled(this.config.getBoolean("xmpp.sasl-enabled", false));
        connConf.setSendPresence(true);
        connConf.setReconnectionAllowed(true);
        connConf.setDebuggerEnabled(this.config.getBoolean("debug", false));
        if (requireTLS) {
            connConf.setSecurityMode(ConnectionConfiguration.SecurityMode.required);
        }
        this.connection = new XMPPConnection(connConf);
        try {
            this.connection.connect();
            this.connection.login(xmppuser, password, "Essentials-XMPP");
            this.connection.sendPacket(new Presence(Presence.Type.available, "No one online.", 2, Presence.Mode.available));
            this.connection.getRoster().setSubscriptionMode(Roster.SubscriptionMode.accept_all);
            this.chatManager = this.connection.getChatManager();
            this.chatManager.addChatListener(this);
            return true;
        }
        catch (XMPPException ex) {
            logger.log(Level.WARNING, "Failed to connect to server: " + server, ex);
            logger.log(Level.WARNING, "Connected: " + this.connection.isConnected());
            logger.log(Level.WARNING, "Secure: " + this.connection.isSecureConnection());
            logger.log(Level.WARNING, "Using TLS: " + this.connection.isUsingTLS());
            logger.log(Level.WARNING, "Authenticated: " + this.connection.getSASLAuthentication().isAuthenticated());
            return false;
        }
    }

    final void disconnect() {
        if (this.loggerThread != null) {
            this.loggerThread.interrupt();
        }
        if (this.chatManager != null) {
            this.chatManager.removeChatListener(this);
            this.chatManager = null;
        }
        if (this.connection != null) {
            this.connection.disconnect(new Presence(Presence.Type.unavailable));
        }
    }

    final void updatePresence() {
        String presenceMsg;
        if (this.connection == null) {
            this.parent.getEss().getLogger().warning(I18n.tl((String)"xmppNotConfigured", (Object[])new Object[0]));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int usercount = this.parent.getEss().getOnlinePlayers().size();
        if (usercount == 0) {
            presenceMsg = "No one online.";
            this.connection.sendPacket(new Presence(Presence.Type.available, "No one online.", 2, Presence.Mode.dnd));
        }
        if (usercount == 1) {
            presenceMsg = "1 player online.";
            this.connection.sendPacket(new Presence(Presence.Type.available, "1 player online.", 2, Presence.Mode.available));
        }
        if (usercount > 1) {
            stringBuilder.append(usercount).append(" players online.");
            this.connection.sendPacket(new Presence(Presence.Type.available, stringBuilder.toString(), 2, Presence.Mode.available));
        }
    }

    @Override
    public void chatCreated(Chat chat, boolean createdLocally) {
        if (!createdLocally) {
            chat.addMessageListener(this);
            Chat old = this.chats.put(StringUtils.parseBareAddress(chat.getParticipant()), chat);
            if (old != null) {
                old.removeMessageListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadConfig() {
        logger.removeHandler(this);
        this.config.load();
        Map<String, Chat> map = this.chats;
        synchronized (map) {
            this.disconnect();
            this.chats.clear();
            if (!this.connect()) {
                return;
            }
            this.startLoggerThread();
        }
        if (this.config.getBoolean("log-enabled", false)) {
            logger.addHandler(this);
            this.logUsers = this.config.getStringList("log-users");
            String level = this.config.getString("log-level", "info");
            try {
                this.logLevel = Level.parse(level.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                this.logLevel = Level.INFO;
            }
            this.ignoreLagMessages = this.config.getBoolean("ignore-lag-messages", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        block6: {
            try {
                if (this.ignoreLagMessages && logRecord.getMessage().equals("Can't keep up! Did the system time change, or is the server overloaded?")) {
                    return;
                }
                if (logRecord.getLevel().intValue() < this.logLevel.intValue()) break block6;
                Set<LogRecord> set = this.logrecords;
                synchronized (set) {
                    this.logrecords.add(logRecord);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private void startLoggerThread() {
        this.loggerThread = new Thread(() -> {
            HashSet<LogRecord> copy = new HashSet<LogRecord>();
            HashSet<String> failedUsers = new HashSet<String>();
            while (this.threadrunning) {
                Set<LogRecord> set = this.logrecords;
                synchronized (set) {
                    if (!this.logrecords.isEmpty()) {
                        copy.addAll(this.logrecords);
                        this.logrecords.clear();
                    }
                }
                if (!copy.isEmpty()) {
                    for (String user : this.logUsers) {
                        try {
                            this.startChat(user);
                            for (LogRecord logRecord : copy) {
                                String message = formatter.format(logRecord);
                                if (this.sendMessage(user, FormatUtil.stripLogColorFormat((String)message))) continue;
                                failedUsers.add(user);
                            }
                        }
                        catch (XMPPException ex) {
                            failedUsers.add(user);
                            logger.removeHandler(this);
                            logger.log(Level.SEVERE, "Failed to deliver log message! Disabling logging to XMPP.", ex);
                        }
                    }
                    this.logUsers.removeAll(failedUsers);
                    if (this.logUsers.isEmpty()) {
                        logger.removeHandler(this);
                        this.threadrunning = false;
                    }
                    copy.clear();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    this.threadrunning = false;
                }
            }
            logger.removeHandler(this);
        });
        this.loggerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startChat(String address) throws XMPPException {
        if (this.chatManager == null) {
            return;
        }
        Map<String, Chat> map = this.chats;
        synchronized (map) {
            if (!this.chats.containsKey(address)) {
                Chat chat = this.chatManager.createChat(address, this);
                if (chat == null) {
                    throw new XMPPException("Could not start Chat with " + address);
                }
                this.chats.put(address, chat);
            }
        }
    }

    private void sendPrivateMessage(Chat chat, String message) {
        String[] parts = message.split(" ", 2);
        if (parts.length == 2) {
            List matches = this.parent.getServer().matchPlayer(parts[0].substring(1));
            if (matches.isEmpty()) {
                try {
                    chat.sendMessage("User " + parts[0] + " not found");
                }
                catch (XMPPException ex) {
                    logger.log(Level.WARNING, "Failed to send xmpp message.", ex);
                }
            } else {
                String from = "[" + this.parent.getUserByAddress(StringUtils.parseBareAddress(chat.getParticipant())) + ">";
                for (Player p : matches) {
                    p.sendMessage(from + p.getDisplayName() + "]  " + message);
                }
            }
        }
    }

    private void sendCommand(Chat chat, String message) {
        if (this.config.getStringList("op-users").contains(StringUtils.parseBareAddress(chat.getParticipant()))) {
            this.parent.getServer().getScheduler().runTask((Plugin)this.parent, () -> {
                try {
                    this.parent.getServer().dispatchCommand(Console.getInstance().getCommandSender(), message.substring(1));
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            });
        }
    }

    private void disableChat(String address) {
        Chat chat = this.chats.get(address);
        if (chat != null) {
            chat.removeMessageListener(this);
            this.chats.remove(address);
        }
    }

    public boolean isConfigValid() {
        String server = this.config.getString("xmpp.server");
        return server != null && !server.equals("example.com");
    }
}

