/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.capability;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.message.MobEnchantFromOwnerMessage;
import com.baguchan.enchantwithmob.message.MobEnchantedMessage;
import com.baguchan.enchantwithmob.message.RemoveAllMobEnchantMessage;
import com.baguchan.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class MobEnchantCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundNBT> {
    private List<MobEnchantHandler> mobEnchants = Lists.newArrayList();
    private Optional<LivingEntity> enchantOwner = Optional.empty();
    private boolean fromOwner;

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.field_70170_p.field_72995_K) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void addMobEnchantFromOwner(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel, LivingEntity owner) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.field_70170_p.field_72995_K) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.addOwner(entity, owner);
    }

    public void addOwner(LivingEntity entity, @Nullable LivingEntity owner) {
        this.fromOwner = true;
        this.enchantOwner = Optional.ofNullable(owner);
        if (!entity.field_70170_p.field_72995_K) {
            MobEnchantFromOwnerMessage message = new MobEnchantFromOwnerMessage((Entity)entity, (Entity)owner);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void removeOwner(LivingEntity entity) {
        this.fromOwner = false;
        this.enchantOwner = Optional.empty();
        if (!entity.field_70170_p.field_72995_K) {
            RemoveMobEnchantOwnerMessage message = new RemoveMobEnchantOwnerMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void removeAllMobEnchant(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.field_70170_p.field_72995_K) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
    }

    public void removeMobEnchantFromOwner(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.field_70170_p.field_72995_K) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        this.removeOwner(entity);
    }

    public void onNewEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.field_70170_p.field_72995_K) {
            enchant.applyAttributesModifiersToEntity(entity, entity.func_233645_dx_(), enchantLevel);
        }
    }

    protected void onChangedEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.field_70170_p.field_72995_K) {
            enchant.applyAttributesModifiersToEntity(entity, entity.func_233645_dx_(), enchantLevel);
        }
    }

    protected void onRemoveEnchantEffect(LivingEntity entity, MobEnchant enchant) {
        if (!entity.field_70170_p.func_201670_d()) {
            enchant.removeAttributesModifiersFromEntity(entity, entity.func_233645_dx_());
        }
    }

    public List<MobEnchantHandler> getMobEnchants() {
        return this.mobEnchants;
    }

    public boolean hasEnchant() {
        return !this.mobEnchants.isEmpty();
    }

    public Optional<LivingEntity> getEnchantOwner() {
        return this.enchantOwner;
    }

    public boolean hasOwner() {
        return this.enchantOwner.isPresent() && this.enchantOwner.get().func_70089_S();
    }

    public boolean isFromOwner() {
        return this.fromOwner;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == EnchantWithMob.MOB_ENCHANT_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            listnbt.add((Object)this.mobEnchants.get(i).writeNBT());
        }
        nbt.func_218657_a("StoredMobEnchants", (INBT)listnbt);
        nbt.func_74757_a("FromOwner", this.fromOwner);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT list = MobEnchantUtils.getEnchantmentListForNBT(nbt);
        this.mobEnchants.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compoundnbt = list.func_150305_b(i);
            this.mobEnchants.add(new MobEnchantHandler(MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt)));
        }
        this.fromOwner = nbt.func_74767_n("FromOwner");
    }
}

