/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class OptionCSArgumentType
implements ArgumentType<String> {
    protected OptionCSArgumentType() {
    }

    public static OptionCSArgumentType option() {
        return new OptionCSArgumentType();
    }

    public static String getOption(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        String str = (String)context.getArgument(name, String.class);
        String s = str.toLowerCase(Locale.ROOT);
        if (!s.equals(str)) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.shrines.failure.lower_case", new Object[]{"structure-name"}));
        }
        if (CustomStructureData.OPTIONS.stream().anyMatch(n -> n.equals(s))) {
            return s;
        }
        throw new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.shrines.failure.option", new Object[]{s})).create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> cct, SuggestionsBuilder sb) {
        return cct.getSource() instanceof ISuggestionProvider ? ISuggestionProvider.func_197013_a(CustomStructureData.OPTIONS.stream(), (SuggestionsBuilder)sb) : Suggestions.empty();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && OptionCSArgumentType.isAllowedChar(reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        return s;
    }

    public static boolean isAllowedChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == ':' || ch == '/' || ch == '.' || ch == '-';
    }

    public Collection<String> getExamples() {
        return CustomStructureData.OPTIONS;
    }
}

