/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.silverminer.shrines.commands.NameCSArgumentType;
import com.silverminer.shrines.commands.NewNameCSArgumentType;
import com.silverminer.shrines.structures.custom.helper.ConfigOption;
import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import com.silverminer.shrines.utils.OptionParsingResult;
import com.silverminer.shrines.utils.Utils;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ShrinesCommand {
    public static void register(CommandDispatcher<CommandSource> p_198528_0_) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"shrines-structures").requires(ctx -> ctx.func_197034_c(2));
        RequiredArgumentBuilder options = Commands.func_197056_a((String)"structure-name", (ArgumentType)NameCSArgumentType.name());
        for (ConfigOption<?> co : new CustomStructureData((String)"dummy", (int)0).CONFIGS) {
            options = (RequiredArgumentBuilder)options.then(Commands.func_197057_a((String)co.getName()).then(Commands.func_197056_a((String)"value", co.getArgument()).executes(ctx -> ShrinesCommand.configure((CommandSource)ctx.getSource(), NameCSArgumentType.getName((CommandContext<CommandSource>)ctx, "structure-name"), co.getName(), co.getCommandValue((CommandContext<CommandSource>)ctx, co.getName())))));
        }
        literalargumentbuilder = (LiteralArgumentBuilder)literalargumentbuilder.then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure-name", (ArgumentType)NewNameCSArgumentType.name()).executes(ctx -> ShrinesCommand.add((CommandSource)ctx.getSource(), NewNameCSArgumentType.getName((CommandContext<CommandSource>)ctx, "structure-name"), new Random().nextInt(Integer.MAX_VALUE)))).then(Commands.func_197056_a((String)"seed", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ShrinesCommand.add((CommandSource)ctx.getSource(), NewNameCSArgumentType.getName((CommandContext<CommandSource>)ctx, "structure-name"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seed"))))));
        literalargumentbuilder = (LiteralArgumentBuilder)literalargumentbuilder.then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure-name", (ArgumentType)NameCSArgumentType.name()).executes(ctx -> ShrinesCommand.remove((CommandSource)ctx.getSource(), NameCSArgumentType.getName((CommandContext<CommandSource>)ctx, "structure-name"), false))).then(Commands.func_197056_a((String)"fromDisk", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ShrinesCommand.remove((CommandSource)ctx.getSource(), NameCSArgumentType.getName((CommandContext<CommandSource>)ctx, "structure-name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"fromDisk"))))));
        literalargumentbuilder = (LiteralArgumentBuilder)literalargumentbuilder.then(Commands.func_197057_a((String)"help").executes(ctx -> ShrinesCommand.help((CommandSource)ctx.getSource())));
        literalargumentbuilder = (LiteralArgumentBuilder)literalargumentbuilder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"query").executes(ctx -> ShrinesCommand.query((CommandSource)ctx.getSource()))).then(Commands.func_197056_a((String)"structure-name", (ArgumentType)NameCSArgumentType.name()).executes(ctx -> ShrinesCommand.query((CommandSource)ctx.getSource(), NameCSArgumentType.getName((CommandContext<CommandSource>)ctx, "structure-name")))));
        literalargumentbuilder = (LiteralArgumentBuilder)literalargumentbuilder.then(Commands.func_197057_a((String)"configure").then((ArgumentBuilder)options));
        p_198528_0_.register(literalargumentbuilder);
    }

    public static int help(CommandSource ctx) throws CommandSyntaxException {
        IFormattableTextComponent help = new TranslationTextComponent("commands.shrines.help.help").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Silverminer007/Shrines/wiki/Adding-Custom-Structures")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("commands.shrines.help.tooltip"))));
        ctx.func_197030_a((ITextComponent)new TranslationTextComponent("commands.shrines.help", new Object[]{help}), false);
        return 0;
    }

    public static int add(CommandSource ctx, String name, int seed) throws CommandSyntaxException {
        TranslationTextComponent message;
        int ret = 0;
        CustomStructureData data = null;
        for (CustomStructureData csd : Utils.customsStructs) {
            if (csd.getName() != name) continue;
            data = csd;
            break;
        }
        if (data != null) {
            message = new TranslationTextComponent("commands.shrines.add.failed", new Object[]{name});
            ret = -1;
        } else {
            Utils.customsStructs.add(new CustomStructureData(name, seed));
            IFormattableTextComponent conf = new TranslationTextComponent("commands.shrines.add.success.help").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/shrines-structures configure " + name + " ")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("commands.shrines.add.success.help.tooltip"))));
            message = new TranslationTextComponent("commands.shrines.add.success", new Object[]{name, conf});
        }
        ctx.func_197030_a((ITextComponent)message, false);
        return ret;
    }

    public static int remove(CommandSource ctx, String name, boolean fromDisk) {
        TranslationTextComponent message;
        if (!Utils.customsStructs.removeIf(csd -> csd.getName().equals(name))) {
            message = new TranslationTextComponent("commands.shrines.remove.failed", new Object[]{name});
        } else {
            message = new TranslationTextComponent("commands.shrines.remove.success", new Object[]{name});
            if (fromDisk) {
                Utils.customsToDelete.add(name);
            }
        }
        ctx.func_197030_a((ITextComponent)message, false);
        return 0;
    }

    public static int configure(CommandSource ctx, String name, String option, Object value) throws CommandSyntaxException {
        OptionParsingResult res;
        CustomStructureData data = Utils.getData(name);
        Object message = data == null ? new TranslationTextComponent("commands.shrines.configure.failed.structure", new Object[]{name}) : ((res = data.fromString(option, value.toString())).isSuccess() ? new TranslationTextComponent("commands.shrines.configure.success", new Object[]{name}) : (res.getMessage() == null ? new TranslationTextComponent("commands.shrines.configure.failed.option", new Object[]{name, option}) : res.getMessage()));
        ctx.func_197030_a((ITextComponent)message, false);
        return 0;
    }

    public static int query(CommandSource ctx) throws CommandSyntaxException {
        String output = "";
        for (int i = 0; i < Utils.customsStructs.size(); ++i) {
            output = output + "\n\"" + Utils.customsStructs.get(i).getName() + "\"";
        }
        ctx.func_197030_a((ITextComponent)new TranslationTextComponent("commands.shrines.query.structure", new Object[]{Utils.customsStructs.size(), output}), false);
        return 0;
    }

    public static int query(CommandSource ctx, String name) throws CommandSyntaxException {
        CustomStructureData data = Utils.getData(name);
        TranslationTextComponent output = data == null ? new TranslationTextComponent("commands.shrines.query.option.failed", new Object[]{name}) : new TranslationTextComponent("commands.shrines.query.option.success", new Object[]{name, data.toStringReadAble()});
        ctx.func_197030_a((ITextComponent)output, false);
        return 0;
    }
}

