/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureConfig {
    public final LootableStructureGenConfig BALLON;
    public final LootableStructureGenConfig BEES;
    public final LootableStructureGenConfig HIGH_TEMPEL;
    public final LootableStructureGenConfig SMALL_TEMPEL;
    public final LootableStructureGenConfig NETHER_SHRINE;
    public final LootableStructureGenConfig NETHER_PYRAMID;
    public final LootableStructureGenConfig WATER_SHRINE;
    public final LootableStructureGenConfig PLAYER_HOUSE;
    public final LootableStructureGenConfig MINERAL_TEMPLE;
    public final LootableStructureGenConfig FLOODED_TEMPLE;
    public final HarbourStructureGenConfig HARBOUR;
    public final LootableStructureGenConfig INFESTED_PRISON;
    public final LootableStructureGenConfig WITCH_HOUSE;
    public final LootableStructureGenConfig JUNGLE_TOWER;
    public final LootableStructureGenConfig GUARDIAN_MEETING;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_BIOMES;
    public final LootableStructureGenConfig END_TEMPLE;
    public final LootableStructureGenConfig CUSTOM;

    public StructureConfig(ForgeConfigSpec.Builder SERVER_BUILDER) {
        this.BALLON = new LootableStructureGenConfig.LootableConfigBuilder("Ballon", "ballon", 143665).setLootChance(0.25).setDistance(50).setSeparation(8).setNeedsGround(false).build(SERVER_BUILDER);
        this.BEES = new LootableStructureGenConfig.LootableConfigBuilder("Bees", "bees", 779806245).setDistance(70).setSeparation(12).setUseRandomVarianting(false).build(SERVER_BUILDER);
        this.HIGH_TEMPEL = new LootableStructureGenConfig.LootableConfigBuilder("High Tempel", "high_tempel", 536987987).setDistance(85).setSeparation(18).build(SERVER_BUILDER);
        this.SMALL_TEMPEL = new LootableStructureGenConfig.LootableConfigBuilder("Small Tempel", "small_tempel", 4765321).setDistance(75).setSeparation(13).build(SERVER_BUILDER);
        this.NETHER_SHRINE = new LootableStructureGenConfig.LootableConfigBuilder("Nether Shrine", "nether_shrine", 653267).setDistance(80).setSeparation(15).build(SERVER_BUILDER);
        this.NETHER_PYRAMID = new LootableStructureGenConfig.LootableConfigBuilder("Nether Pyramid", "nether_pyramid", 7428394).setDistance(150).setSeparation(50).build(SERVER_BUILDER);
        this.WATER_SHRINE = new LootableStructureGenConfig.LootableConfigBuilder("Water Shrine", "water_shrine", 643168754).setDistance(80).setSeparation(15).build(SERVER_BUILDER);
        this.PLAYER_HOUSE = new LootableStructureGenConfig.LootableConfigBuilder("Player House", "player_house", 751963298).setDistance(80).setSeparation(15).build(SERVER_BUILDER);
        this.MINERAL_TEMPLE = new LootableStructureGenConfig.LootableConfigBuilder("Mineral Temple", "mineral_temple", 576143753).setDistance(50).setSeparation(10).setUseRandomVarianting(false).build(SERVER_BUILDER);
        this.FLOODED_TEMPLE = new LootableStructureGenConfig.LootableConfigBuilder("Flooded Temple", "flooded_temple", 54315143).setDistance(50).setSeparation(10).setUseRandomVarianting(false).build(SERVER_BUILDER);
        this.HARBOUR = new HarbourStructureGenConfig.LootableHarbourConfigBuilder("Harbour", "harbour", 651398043).setDistance(50).setSeparation(8).setBiomes(Biome.Category.PLAINS, Biome.Category.FOREST, Biome.Category.TAIGA, Biome.Category.SAVANNA, Biome.Category.JUNGLE, Biome.Category.MESA, Biome.Category.ICY, Biome.Category.SWAMP, Biome.Category.MUSHROOM).setNeedsGround(false).build(SERVER_BUILDER);
        this.INFESTED_PRISON = new LootableStructureGenConfig.LootableConfigBuilder("Infested Prison", "infested_prison", 567483014).setDistance(60).setSeparation(11).build(SERVER_BUILDER);
        this.WITCH_HOUSE = new LootableStructureGenConfig.LootableConfigBuilder("Abandoned Witch House", "witch_house", 1721882513).setBiomes(Biome.Category.SWAMP, Biome.Category.FOREST).addToBlacklist("minecraft:flower_forest", "minecraft:tall_birch_forest", "minecraft:forest", "minecraft:birch_forest", "minecraft:birch_forest_hills").setDistance(60).setSeparation(11).build(SERVER_BUILDER);
        this.JUNGLE_TOWER = new LootableStructureGenConfig.LootableConfigBuilder("Jungle Tower", "jungle_tower", 987531843).setDistance(60).setSeparation(11).setBiomes(Biome.Category.JUNGLE).build(SERVER_BUILDER);
        this.GUARDIAN_MEETING = new LootableStructureGenConfig.LootableConfigBuilder("Guardian Meeting", "guardian_meeting", 1498473232).setLootChance(1.0).setDistance(70).setSeparation(17).setUseRandomVarianting(false).build(SERVER_BUILDER);
        this.BLACKLISTED_BIOMES = SERVER_BUILDER.comment(new String[]{"Structure Generation Config", "Take care what you change, this changes may cant be undone", "", "Biomes in which Overworld Structures cant generate in"}).defineList("structures.blacklisted_biomes", StructureConfig.getAllBiomesForCategory(Biome.Category.THEEND, Biome.Category.NETHER), StructureConfig::validateBiome);
        this.END_TEMPLE = new LootableStructureGenConfig.LootableConfigBuilder("End Temple", "end_temple", 478360).setDistance(60).setSeparation(11).setBiomes(Biome.Category.THEEND).addToBlacklist("minecraft:the_end", "minecraft:the_void", "minecraft:small_end_islands").build(SERVER_BUILDER);
        this.CUSTOM = null;
    }

    private static boolean validateBiome(Object o) {
        return o == null || ForgeRegistries.BIOMES.containsKey(new ResourceLocation((String)o));
    }

    private static boolean validateBiomeCategory(Object o) {
        for (Biome.Category category : Biome.Category.values()) {
            try {
                if (category != Biome.Category.valueOf((String)((String)o))) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public static List<String> getAllBiomesForCategory(Biome.Category ... categories) {
        ArrayList<String> biomes = new ArrayList<String>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            for (Biome.Category category : categories) {
                if (biome.func_201856_r() != category) continue;
                biomes.add(Objects.requireNonNull(biome.getRegistryName()).toString());
            }
        }
        return biomes;
    }

    public static class LootableStructureGenConfig
    extends StructureGenConfig {
        public final ForgeConfigSpec.DoubleValue LOOT_CHANCE;

        public LootableStructureGenConfig(ForgeConfigSpec.Builder SERVER_BUILDER, String name, String dataName, double dSpawnChance, int dDistance, int dSeparation, int dSeed, double dLootChance, boolean needsGround, boolean useRandomVarianting, ArrayList<String> blacklist, Biome.Category ... biomeCategories) {
            super(SERVER_BUILDER, name, dataName, dSpawnChance, dDistance, dSeparation, dSeed, needsGround, useRandomVarianting, blacklist, biomeCategories);
            this.LOOT_CHANCE = SERVER_BUILDER.comment(name + " Generate Loot Chance [default: " + dLootChance + "]").defineInRange("structures." + dataName.toLowerCase(Locale.ROOT) + ".loot_chance", dLootChance, 0.0, 1.0);
        }

        public static class LootableConfigBuilder
        extends StructureGenConfig.ConfigBuilder {
            protected double lootChance = 1.0;

            public LootableConfigBuilder(String name, String dataName, int seed) {
                super(name, dataName, seed);
            }

            @Override
            public LootableStructureGenConfig build(ForgeConfigSpec.Builder SERVER_BUILDER) {
                return new LootableStructureGenConfig(SERVER_BUILDER, this.name, this.dataName, this.spawnChance, this.distance, this.separation, this.seed, this.lootChance, this.needsGround, this.useRandomVarianting, this.blacklist, this.biomes);
            }

            public LootableConfigBuilder setLootChance(double lootChance) {
                this.lootChance = lootChance;
                return this;
            }

            @Override
            public LootableConfigBuilder addToBlacklist(String ... blacklist) {
                for (String s : blacklist) {
                    this.blacklist.add(s);
                }
                return this;
            }

            @Override
            public LootableConfigBuilder setSpawnChance(double spawnChance) {
                this.spawnChance = spawnChance;
                return this;
            }

            @Override
            public LootableConfigBuilder setDistance(int distance) {
                this.distance = distance;
                return this;
            }

            @Override
            public LootableConfigBuilder setSeparation(int separation) {
                this.separation = separation;
                return this;
            }

            @Override
            public LootableConfigBuilder setNeedsGround(boolean needsGround) {
                this.needsGround = needsGround;
                return this;
            }

            @Override
            public LootableConfigBuilder setBiomes(Biome.Category ... biomes) {
                this.biomes = biomes;
                return this;
            }

            @Override
            public LootableConfigBuilder setUseRandomVarianting(boolean useRandomVarianting) {
                this.useRandomVarianting = useRandomVarianting;
                return this;
            }
        }
    }

    public static class HarbourStructureGenConfig
    extends LootableStructureGenConfig {
        public final ForgeConfigSpec.BooleanValue SPAWN_VILLAGERS;

        public HarbourStructureGenConfig(ForgeConfigSpec.Builder SERVER_BUILDER, String name, String dataName, double dSpawnChance, int dDistance, int dSeparation, int dSeed, double dLootChance, boolean needsGround, boolean useRandomVarianting, ArrayList<String> blacklist, boolean spawnVillagers, Biome.Category ... biomeCategories) {
            super(SERVER_BUILDER, name, dataName, dSpawnChance, dDistance, dSeparation, dSeed, dLootChance, needsGround, useRandomVarianting, blacklist, biomeCategories);
            this.SPAWN_VILLAGERS = SERVER_BUILDER.comment(name + " Spawn Villagers [default: " + spawnVillagers + "]").define("structures." + dataName.toLowerCase(Locale.ROOT) + ".spawn_villagers", spawnVillagers);
        }

        public static class LootableHarbourConfigBuilder
        extends LootableStructureGenConfig.LootableConfigBuilder {
            protected boolean spawn_villagers = true;

            public LootableHarbourConfigBuilder(String name, String dataName, int seed) {
                super(name, dataName, seed);
            }

            @Override
            public HarbourStructureGenConfig build(ForgeConfigSpec.Builder SERVER_BUILDER) {
                return new HarbourStructureGenConfig(SERVER_BUILDER, this.name, this.dataName, this.spawnChance, this.distance, this.separation, this.seed, this.lootChance, this.needsGround, this.useRandomVarianting, (ArrayList<String>)this.blacklist, this.spawn_villagers, this.biomes);
            }

            public LootableHarbourConfigBuilder setSpawnVillagers(boolean spawn_villagers) {
                this.spawn_villagers = spawn_villagers;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setLootChance(double lootChance) {
                this.lootChance = lootChance;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder addToBlacklist(String ... blacklist) {
                for (String s : blacklist) {
                    this.blacklist.add(s);
                }
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setSpawnChance(double spawnChance) {
                this.spawnChance = spawnChance;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setDistance(int distance) {
                this.distance = distance;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setSeparation(int separation) {
                this.separation = separation;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setNeedsGround(boolean needsGround) {
                this.needsGround = needsGround;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setBiomes(Biome.Category ... biomes) {
                this.biomes = biomes;
                return this;
            }

            @Override
            public LootableHarbourConfigBuilder setUseRandomVarianting(boolean useRandomVarianting) {
                this.useRandomVarianting = useRandomVarianting;
                return this;
            }
        }
    }

    public static class StructureGenConfig {
        public final ForgeConfigSpec.BooleanValue GENERATE;
        public final ForgeConfigSpec.DoubleValue SPAWN_CHANCE;
        public final ForgeConfigSpec.BooleanValue NEEDS_GROUND;
        public final ForgeConfigSpec.IntValue DISTANCE;
        public final ForgeConfigSpec.IntValue SEPARATION;
        public final ForgeConfigSpec.IntValue SEED;
        public final ForgeConfigSpec.ConfigValue<List<? extends Biome.Category>> BIOME_CATEGORIES;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> BIOME_BLACKLIST;
        public final ForgeConfigSpec.BooleanValue USE_RANDOM_VARIANTING;

        public StructureGenConfig(ForgeConfigSpec.Builder SERVER_BUILDER, String name, String dataName, double dSpawnChance, int dDistance, int dSeparation, int dSeed, boolean needsGround, boolean useRandomVarianting, ArrayList<String> blacklist, Biome.Category ... biomeCategories) {
            Biome.Category[] categoryArray;
            if (biomeCategories == null) {
                Biome.Category[] categoryArray2 = new Biome.Category[3];
                categoryArray2[0] = Biome.Category.PLAINS;
                categoryArray2[1] = Biome.Category.FOREST;
                categoryArray = categoryArray2;
                categoryArray2[2] = Biome.Category.TAIGA;
            } else {
                categoryArray = biomeCategories;
            }
            biomeCategories = categoryArray;
            dataName = dataName.toLowerCase(Locale.ROOT);
            this.GENERATE = SERVER_BUILDER.comment("Generate " + name + "s?").define("structures." + dataName + ".generate", true);
            this.NEEDS_GROUND = SERVER_BUILDER.comment("Needs " + name + " Ground? [default: " + needsGround + "]").define("structures." + dataName + ".needs_ground", needsGround);
            this.SPAWN_CHANCE = SERVER_BUILDER.comment(name + " Spawn Chance [default: " + dSpawnChance + "]").defineInRange("structures." + dataName + ".spawn_chance", dSpawnChance, 0.0, 1.0);
            this.DISTANCE = SERVER_BUILDER.comment(name + " Distance (in chunks) [default: " + dDistance + "]").defineInRange("structures." + dataName + ".distance", dDistance, 1, 500);
            this.SEPARATION = SERVER_BUILDER.comment(name + " Minimum Separation (in chunks) [default: " + dSeparation + "]").defineInRange("structures." + dataName + ".separation", dSeparation, 1, 500);
            this.SEED = SERVER_BUILDER.comment(name + " Seed (Only Change if you know what you are doing)[default: " + dSeed + "]").defineInRange("structures." + dataName + ".seed", dSeed, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.BIOME_CATEGORIES = SERVER_BUILDER.comment("Biome Types the " + name + " can generate in").defineList("structures." + dataName + ".biome_categories", Arrays.asList(biomeCategories), x$0 -> StructureConfig.validateBiomeCategory(x$0));
            this.BIOME_BLACKLIST = SERVER_BUILDER.comment("Biomes the " + name + " can NOT generate in").defineList("structures." + dataName + ".biome_blacklist", blacklist, x$0 -> StructureConfig.validateBiome(x$0));
            this.USE_RANDOM_VARIANTING = SERVER_BUILDER.comment("Use Random Varianting for " + name + "? [default: " + useRandomVarianting + "]").define("structures." + dataName + ".varianting", useRandomVarianting);
        }

        public static class ConfigBuilder {
            protected final String name;
            protected final String dataName;
            protected final int seed;
            protected double spawnChance = 0.6;
            protected int distance = 60;
            protected int separation = 12;
            protected boolean needsGround = true;
            protected boolean useRandomVarianting = true;
            protected ArrayList<String> blacklist = Lists.newArrayList();
            protected Biome.Category[] biomes = new Biome.Category[]{Biome.Category.PLAINS, Biome.Category.FOREST, Biome.Category.TAIGA, Biome.Category.SAVANNA, Biome.Category.JUNGLE, Biome.Category.MESA, Biome.Category.ICY, Biome.Category.DESERT, Biome.Category.SWAMP, Biome.Category.MUSHROOM};

            public ConfigBuilder(String name, String dataName, int seed) {
                this.name = name;
                this.dataName = dataName;
                this.seed = seed;
            }

            public StructureGenConfig build(ForgeConfigSpec.Builder SERVER_BUILDER) {
                return new StructureGenConfig(SERVER_BUILDER, this.name, this.dataName, this.spawnChance, this.distance, this.separation, this.seed, this.needsGround, this.useRandomVarianting, this.blacklist, this.biomes);
            }

            public ConfigBuilder addToBlacklist(String ... blacklist) {
                for (String s : blacklist) {
                    this.blacklist.add(s);
                }
                return this;
            }

            public ConfigBuilder setSpawnChance(double spawnChance) {
                this.spawnChance = spawnChance;
                return this;
            }

            public ConfigBuilder setDistance(int distance) {
                this.distance = distance;
                return this;
            }

            public ConfigBuilder setSeparation(int separation) {
                this.separation = separation;
                return this;
            }

            public ConfigBuilder setNeedsGround(boolean needsGround) {
                this.needsGround = needsGround;
                return this;
            }

            public ConfigBuilder setBiomes(Biome.Category ... biomes) {
                this.biomes = biomes;
                return this;
            }

            public ConfigBuilder setUseRandomVarianting(boolean useRandomVarianting) {
                this.useRandomVarianting = useRandomVarianting;
                return this;
            }
        }
    }
}

