/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.events;

import com.mojang.brigadier.CommandDispatcher;
import com.silverminer.shrines.commands.ShrinesCommand;
import com.silverminer.shrines.config.Config;
import com.silverminer.shrines.init.ModStructureFeatures;
import com.silverminer.shrines.structures.Generator;
import com.silverminer.shrines.structures.StructurePieceTypes;
import com.silverminer.shrines.structures.custom.CustomStructure;
import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import com.silverminer.shrines.utils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonEvents {
    protected static final Logger LOGGER = LogManager.getLogger(CommonEvents.class);

    @Mod.EventBusSubscriber(modid="shrines", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventBus {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBiomeLoadHigh(BiomeLoadingEvent event) {
            LOGGER.debug("Loading Biome and registering structures. Biome: {}", (Object)event.getName());
            if (!((List)Config.STRUCTURES.BLACKLISTED_BIOMES.get()).contains(event.getName().toString())) {
                if (((Boolean)Config.STRUCTURES.BALLON.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.BALLON.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.BALLON.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.BALLON);
                }
                if (((Boolean)Config.STRUCTURES.BEES.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.BEES.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.BEES.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.BEES);
                }
                if (((Boolean)Config.STRUCTURES.HIGH_TEMPEL.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.HIGH_TEMPEL.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.HIGH_TEMPEL.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.HIGH_TEMPEL);
                }
                if (((Boolean)Config.STRUCTURES.MINERAL_TEMPLE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.MINERAL_TEMPLE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.MINERAL_TEMPLE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.MINERAL_TEMPLE);
                }
                if (((Boolean)Config.STRUCTURES.FLOODED_TEMPLE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.FLOODED_TEMPLE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.FLOODED_TEMPLE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.FLOODED_TEMPLE);
                }
                if (((Boolean)Config.STRUCTURES.NETHER_PYRAMID.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.NETHER_PYRAMID.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.NETHER_PYRAMID.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.NETHER_PYRAMID);
                }
                if (((Boolean)Config.STRUCTURES.NETHER_SHRINE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.NETHER_SHRINE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.NETHER_SHRINE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.NETHER_SHRINE);
                }
                if (((Boolean)Config.STRUCTURES.PLAYER_HOUSE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.PLAYER_HOUSE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.PLAYER_HOUSE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.PLAYER_HOUSE);
                }
                if (((Boolean)Config.STRUCTURES.SMALL_TEMPEL.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.SMALL_TEMPEL.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.SMALL_TEMPEL.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.SMALL_TEMPEL);
                }
                if (((Boolean)Config.STRUCTURES.WATER_SHRINE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.WATER_SHRINE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.WATER_SHRINE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.WATER_SHRINE);
                }
                if (((Boolean)Config.STRUCTURES.HARBOUR.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.HARBOUR.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.HARBOUR.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.HARBOUR);
                }
                if (((Boolean)Config.STRUCTURES.INFESTED_PRISON.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.INFESTED_PRISON.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.INFESTED_PRISON.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.INFESTED_PRISON);
                }
                if (((Boolean)Config.STRUCTURES.WITCH_HOUSE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.WITCH_HOUSE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.WITCH_HOUSE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.WITCH_HOUSE);
                }
                if (((Boolean)Config.STRUCTURES.JUNGLE_TOWER.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.JUNGLE_TOWER.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.JUNGLE_TOWER.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.JUNGLE_TOWER);
                }
                if (((Boolean)Config.STRUCTURES.GUARDIAN_MEETING.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.GUARDIAN_MEETING.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.GUARDIAN_MEETING.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                    event.getGeneration().func_242516_a(ModStructureFeatures.GUARDIAN_MEETING);
                }
            }
            if (((Boolean)Config.STRUCTURES.END_TEMPLE.GENERATE.get()).booleanValue() && ForgeEventBus.checkBiome((List)Config.STRUCTURES.END_TEMPLE.BIOME_CATEGORIES.get(), (List)Config.STRUCTURES.END_TEMPLE.BIOME_BLACKLIST.get(), event.getName(), event.getCategory())) {
                event.getGeneration().func_242516_a(ModStructureFeatures.END_TEMPLE);
            }
            for (StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> s : ModStructureFeatures.USERS_STRUCTURES) {
                CustomStructure cS;
                if (!(s.field_236268_b_ instanceof CustomStructure) || !(cS = (CustomStructure)s.field_236268_b_).validateSpawn(event.getName(), event.getCategory())) continue;
                event.getGeneration().func_242516_a(s);
            }
        }

        private static boolean checkBiome(List<? extends Object> allowedBiomeCategories, List<? extends String> blacklistedBiomes, ResourceLocation name, Biome.Category category) {
            boolean flag;
            boolean bl = flag = allowedBiomeCategories.contains(category.toString()) || allowedBiomeCategories.contains(category);
            if (!blacklistedBiomes.isEmpty() && flag) {
                flag = !blacklistedBiomes.contains(name.toString());
            }
            return flag;
        }

        @SubscribeEvent
        public static void onServerStop(FMLServerStoppingEvent event) {
            File path = event.getServer().func_71209_f("");
            try {
                File structures;
                path = new File(path, "shrines-saves").getCanonicalFile();
                LOGGER.info("Saving config options on path: {}", (Object)path);
                if (!path.exists()) {
                    path.mkdirs();
                }
                if (!(structures = new File(path, "structures.txt")).exists()) {
                    structures.createNewFile();
                }
                for (String key : Utils.customsToDelete) {
                    File st = new File(path, "shrines");
                    if (!(st = new File(st, key)).isDirectory()) continue;
                    for (File f : st.listFiles()) {
                        f.delete();
                    }
                    st.delete();
                    LOGGER.info("Deleted {} from disk", (Object)st);
                }
                FileWriter fw = new FileWriter(structures);
                for (CustomStructureData data : Utils.customsStructs) {
                    String key = data.getName();
                    LOGGER.debug("Writing config options of custom structure with name {}", (Object)key);
                    fw.write(key + "\n");
                    File st = new File(path, "shrines");
                    st = new File(st, key);
                    if (!st.isDirectory()) {
                        st.mkdirs();
                    }
                    if (!(st = new File(st, key + ".txt")).exists()) {
                        st.createNewFile();
                    }
                    FileWriter cfw = new FileWriter(st);
                    cfw.write(data.toStringReadAble());
                    cfw.close();
                }
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            LOGGER.debug("Registering shrines commands");
            ShrinesCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        }
    }

    @Mod.EventBusSubscriber(modid="shrines", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBus {
        @SubscribeEvent
        public static void commonSetupEvent(FMLLoadCompleteEvent event) {
            event.enqueueWork(() -> {
                LOGGER.debug("Registering structure pieces and structures to dimensions");
                Generator.setupWorldGen();
                StructurePieceTypes.regsiter();
            });
        }
    }
}

