/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.silverminer.shrines.init.StructureInit;
import com.silverminer.shrines.structures.custom.CustomStructure;
import com.silverminer.shrines.structures.custom.helper.CustomStructureData;
import com.silverminer.shrines.utils.Utils;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="shrines", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomStructureInit {
    public static final Logger LOGGER = LogManager.getLogger(CustomStructureInit.class);
    public static final ArrayList<RegistryObject<CustomStructure>> USERS_STRUCTURES = new ArrayList();
    public static boolean areStructuresRegistered = false;

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        LOGGER.debug("Registering custom structures");
        for (CustomStructureData csd : Utils.customsStructs) {
            String name = csd.getName().toLowerCase(Locale.ROOT);
            CustomStructure cS = new CustomStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, name, csd);
            cS.setRegistryName("shrines", name);
            if (!Structure.field_236365_a_.containsValue((Object)cS)) {
                Structure.field_236365_a_.putIfAbsent((Object)new ResourceLocation("shrines", name).toString(), (Object)cS);
            }
            if (!Structure.field_236385_u_.containsValue(cS.func_236396_f_())) {
                Structure.field_236385_u_.putIfAbsent(cS, cS.func_236396_f_());
            }
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)cS).build();
            StructureInit.STRUCTURES_LIST.add(cS);
            event.getRegistry().register((IForgeRegistryEntry)cS);
            USERS_STRUCTURES.add((RegistryObject<CustomStructure>)RegistryObject.of((ResourceLocation)new ResourceLocation("shrines", name), (IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES));
        }
        areStructuresRegistered = true;
    }
}

