/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.silverminer.shrines.structures.AbstractStructure;
import com.silverminer.shrines.structures.ballon.BallonStructure;
import com.silverminer.shrines.structures.bees.BeesStructure;
import com.silverminer.shrines.structures.end_temple.EndTempleStructure;
import com.silverminer.shrines.structures.flooded_temple.FloodedTempleStructure;
import com.silverminer.shrines.structures.guardian_meeting.GuardianMeetingStructure;
import com.silverminer.shrines.structures.harbour.HarbourStructure;
import com.silverminer.shrines.structures.high_tempel.HighTempelStructure;
import com.silverminer.shrines.structures.jungle_tower.JungleTowerStructure;
import com.silverminer.shrines.structures.mineral_temple.MineralTempleStructure;
import com.silverminer.shrines.structures.nether_pyramid.NetherPyramidStructure;
import com.silverminer.shrines.structures.nether_shrine.NetherShrineStructure;
import com.silverminer.shrines.structures.player_house.PlayerhouseStructure;
import com.silverminer.shrines.structures.prison.InfestedPrisonStructure;
import com.silverminer.shrines.structures.small_tempel.SmallTempelStructure;
import com.silverminer.shrines.structures.water_shrine.WaterShrineStructure;
import com.silverminer.shrines.structures.witch_house.AbandonedWitchHouseStructure;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureInit {
    protected static final Logger LOGGER = LogManager.getLogger(StructureInit.class);
    public static final ArrayList<AbstractStructure<NoFeatureConfig>> STRUCTURES_LIST = new ArrayList();
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"shrines");
    public static final RegistryObject<NetherShrineStructure> NETHER_SHRINE = StructureInit.register("nether_shrine", new NetherShrineStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<WaterShrineStructure> WATER_SHRINE = StructureInit.register("water_shrine", new WaterShrineStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<BeesStructure> BEES = StructureInit.register("bees", new BeesStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<SmallTempelStructure> SMALL_TEMPEL = StructureInit.register("small_tempel", new SmallTempelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<HighTempelStructure> HIGH_TEMPEL = StructureInit.register("high_tempel", new HighTempelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<BallonStructure> BALLON = StructureInit.register("ballon", new BallonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<NetherPyramidStructure> NETHER_PYRAMID = StructureInit.register("nether_pyramid", new NetherPyramidStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<PlayerhouseStructure> PLAYER_HOUSE = StructureInit.register("player_house", new PlayerhouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MineralTempleStructure> MINERAL_TEMPLE = StructureInit.register("mineral_temple", new MineralTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<FloodedTempleStructure> FLOODED_TEMPLE = StructureInit.register("flooded_temple", new FloodedTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<HarbourStructure> HARBOUR = StructureInit.register("harbour", new HarbourStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<InfestedPrisonStructure> INFESTED_PRISON = StructureInit.register("infested_prison", new InfestedPrisonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<AbandonedWitchHouseStructure> WITCH_HOUSE = StructureInit.register("witch_house", new AbandonedWitchHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<JungleTowerStructure> JUNGLE_TOWER = StructureInit.register("jungle_tower", new JungleTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<EndTempleStructure> END_TEMPLE = StructureInit.register("end_temple", new EndTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<GuardianMeetingStructure> GUARDIAN_MEETING = StructureInit.register("guardian_meeting", new GuardianMeetingStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends AbstractStructure<NoFeatureConfig>> RegistryObject<T> register(String name, T structure) {
        if (!Structure.field_236365_a_.containsValue(structure)) {
            Structure.field_236365_a_.putIfAbsent((Object)new ResourceLocation("shrines", name).toString(), structure);
        }
        if (!Structure.field_236385_u_.containsValue(structure.func_236396_f_())) {
            Structure.field_236385_u_.putIfAbsent(structure, structure.func_236396_f_());
        }
        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        STRUCTURES_LIST.add(structure);
        return STRUCTURES.register(name, () -> structure);
    }
}

