/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.loot_tables;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.ResourceLocation;

public class ShrinesLootTables {
    private static final ArrayList<ResourceLocation> LOOT_TABLES = Lists.newArrayList();
    private static final ArrayList<ResourceLocation> NETHER_LOOT_TABLES = Lists.newArrayList();
    private static final ArrayList<ResourceLocation> VILLAGE_LOOT_TABLES = Lists.newArrayList();
    public static final ResourceLocation NETHER_SHRINE_CHEST = ShrinesLootTables.register("shrines:chests/nether_shrine_chest", true);
    public static final ResourceLocation NETHER_SHRINE_CHEST1 = ShrinesLootTables.register("shrines:chests/nether_shrine_chest1", true);
    public static final ResourceLocation NETHER_SHRINE_CHEST2 = ShrinesLootTables.register("shrines:chests/nether_shrine_chest2", true);
    public static final ResourceLocation NETHER_PYRAMID_CHEST1 = ShrinesLootTables.register("shrines:chests/nether_pyramid_chest1");
    public static final ResourceLocation NETHER_PYRAMID_CHEST2 = ShrinesLootTables.register("shrines:chests/nether_pyramid_chest2");
    public static final ResourceLocation HOUSE_1 = ShrinesLootTables.register("minecraft:chests/village/village_plains_house", false, true);
    public static final ResourceLocation HOUSE_2 = ShrinesLootTables.register("minecraft:chests/village/village_savanna_house", false, true);
    public static final ResourceLocation HOUSE_3 = ShrinesLootTables.register("minecraft:chests/village/village_taiga_house", false, true);
    public static final ResourceLocation HOUSE_4 = ShrinesLootTables.register("minecraft:chests/village/village_snowy_house", false, true);
    public static final ResourceLocation MINERAL_TEMPLE = new ResourceLocation("shrines:chests/mineral_temple_chest");
    public static final ResourceLocation HOUSE_OP = new ResourceLocation("minecraft:chests/village/village_toolsmith");
    public static final ResourceLocation HOUSE_OP_2 = new ResourceLocation("minecraft:chests/village/village_weaponsmith");
    public static final ResourceLocation FURNACE = new ResourceLocation("minecraft:chests/village/village_mason");
    public static final ResourceLocation FURNACE_2 = new ResourceLocation("minecraft:chests/village/village_butcher");
    public static final ResourceLocation HIGH_TEMPEL = new ResourceLocation("shrines:chests/high_tempel_chest");
    public static final ResourceLocation FLOODED_TEMPLE = new ResourceLocation("shrines:chests/flooded_temple_chest");
    public static final ResourceLocation HARBOUR = new ResourceLocation("shrines:chests/harbour_chest");
    public static final ResourceLocation HARBOUR_TAVERN = new ResourceLocation("shrines:chests/harbour_tavern_chest");
    public static final ResourceLocation INFECTED_PRISON = new ResourceLocation("shrines:chests/prison_chest");
    public static final ResourceLocation END_TEMPLE = new ResourceLocation("shrines:chests/end_temple_chest");
    public static final ResourceLocation JUNGLE_TOWER = new ResourceLocation("shrines:chests/jungle_tower_chest");
    public static final ResourceLocation WITCH_HOUSE = new ResourceLocation("shrines:chests/witch_house");
    public static final ResourceLocation SMALL_TEMPEL = new ResourceLocation("shrines:chests/small_tempel");
    public static final ResourceLocation WATER_SHRINE = new ResourceLocation("shrines:chests/water_shrine");
    public static final ResourceLocation BEES = new ResourceLocation("shrines:chests/bees");
    public static final ResourceLocation BALLON = new ResourceLocation("shrines:chests/ballon");
    public static final ResourceLocation GUARDIAN_MEETING = new ResourceLocation("shrines:chests/guardian_meeting");
    public static final ResourceLocation EMPTY = new ResourceLocation("");

    private static ResourceLocation register(String id, boolean isNetherChest, boolean isVillageChest) {
        return ShrinesLootTables.register(new ResourceLocation(id), isNetherChest, isVillageChest);
    }

    private static ResourceLocation register(String id, boolean isNetherChest) {
        return ShrinesLootTables.register(new ResourceLocation(id), isNetherChest);
    }

    private static ResourceLocation register(String id) {
        return ShrinesLootTables.register(new ResourceLocation(id));
    }

    private static ResourceLocation register(ResourceLocation id, boolean isNetherChest, boolean isVillageChest) {
        if (isVillageChest) {
            if (!VILLAGE_LOOT_TABLES.add(id)) {
                throw new IllegalArgumentException(id + " is already a registered built-in loot table");
            }
            return id;
        }
        if (isNetherChest) {
            if (!NETHER_LOOT_TABLES.add(id)) {
                throw new IllegalArgumentException(id + " is already a registered built-in loot table");
            }
            return id;
        }
        if (!LOOT_TABLES.add(id)) {
            throw new IllegalArgumentException(id + " is already a registered built-in loot table");
        }
        return id;
    }

    private static ResourceLocation register(ResourceLocation id, boolean isNetherChest) {
        return ShrinesLootTables.register(id, isNetherChest, false);
    }

    private static ResourceLocation register(ResourceLocation id) {
        return ShrinesLootTables.register(id, false, false);
    }

    public static ResourceLocation getRandomLoot(Random rand) {
        return LOOT_TABLES.get(rand.nextInt(LOOT_TABLES.size()));
    }

    public static ResourceLocation getRandomNetherLoot(Random rand) {
        return NETHER_LOOT_TABLES.get(rand.nextInt(LOOT_TABLES.size()));
    }

    public static ResourceLocation getRandomVillageLoot(Random rand) {
        return VILLAGE_LOOT_TABLES.get(rand.nextInt(LOOT_TABLES.size()));
    }
}

