/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.silverminer.shrines.config.StructureConfig;
import com.silverminer.shrines.init.StructureInit;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractStructure<C extends IFeatureConfig>
extends Structure<C> {
    protected static final Logger LOGGER = LogManager.getLogger(AbstractStructure.class);
    public final int size;
    public final String name;

    public AbstractStructure(Codec<C> codec, int sizeIn, String nameIn) {
        super(codec);
        this.size = sizeIn;
        this.name = nameIn;
    }

    public String func_143025_a() {
        return new ResourceLocation("shrines", this.name).toString();
    }

    protected boolean isSurfaceFlat(@Nonnull ChunkGenerator generator, int chunkX, int chunkZ) {
        int offset = this.getSize() * 16;
        int xStart = chunkX << 4;
        int zStart = chunkZ << 4;
        int i1 = generator.func_222529_a(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222529_a(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222529_a(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222529_a(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        int maxHeight = Math.max(Math.max(i1, j1), Math.max(k1, l1));
        return Math.abs(maxHeight - minHeight) <= 4;
    }

    public int getSize() {
        return this.size;
    }

    public int getDistance() {
        return (Integer)this.getConfig().DISTANCE.get();
    }

    public int getSeparation() {
        return (Integer)this.getConfig().SEPARATION.get();
    }

    public int getSeedModifier() {
        return (Integer)this.getConfig().SEED.get();
    }

    public double getSpawnChance() {
        return (Double)this.getConfig().SPAWN_CHANCE.get();
    }

    public boolean needsGround() {
        return (Boolean)this.getConfig().NEEDS_GROUND.get();
    }

    public abstract StructureConfig.StructureGenConfig getConfig();

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, IFeatureConfig config) {
        return this.validateGeneration(generator, provider, seed, rand, chunkX, chunkZ, biome, pos, config, new Structure[0]);
    }

    public boolean validateGeneration(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, IFeatureConfig config, Structure<?> ... exeptStructure) {
        if (this.isSurfaceFlat(generator, chunkX, chunkZ)) {
            for (Biome biome1 : provider.func_225530_a_(chunkX * 16 + 9, generator.func_230355_e_(), chunkZ * 16 + 9, this.getSize() * 16)) {
                if (biome1.func_242440_e().func_242493_a((Structure)this)) continue;
                return false;
            }
            int i = chunkX >> 4;
            int j = chunkZ >> 4;
            rand.setSeed((long)(i ^ j << 4) ^ seed);
            return rand.nextDouble() < this.getSpawnChance();
        }
        return false;
    }

    protected boolean checkForOtherStructures(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, IFeatureConfig config, Structure<?> ... exeptStructure) {
        for (AbstractStructure<NoFeatureConfig> s : StructureInit.STRUCTURES_LIST) {
            if (exeptStructure != null) {
                for (Structure<?> es : exeptStructure) {
                    if (!es.equals(s)) continue;
                }
            }
            if (!new ChunkPos(chunkX, chunkZ).equals((Object)s.func_236392_a_(new StructureSeparationSettings(s.getDistance(), s.getSeparation(), s.getSeedModifier()), seed, rand, chunkX, chunkZ)) || !s.validateGeneration(generator, provider, seed, rand, chunkX, chunkZ, biome, pos, config, Lists.asList(s, (Object[])exeptStructure).toArray(new Structure[exeptStructure.length]))) continue;
            return false;
        }
        return true;
    }

    public boolean isEndStructure() {
        return false;
    }

    public boolean isNetherStructure() {
        return false;
    }
}

