/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures;

import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractStructurePiece
extends TemplateStructurePiece {
    protected static final Logger LOGGER = LogManager.getLogger(AbstractStructurePiece.class);
    protected final ResourceLocation location;
    protected final Rotation field_186169_c;

    public AbstractStructurePiece(IStructurePieceType pieceType, TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentTypeIn) {
        super(pieceType, componentTypeIn);
        this.location = location;
        this.field_186178_c = pos;
        this.field_186169_c = rotation;
        this.setup(templateManager);
    }

    public AbstractStructurePiece(IStructurePieceType pieceType, TemplateManager templateManager, CompoundNBT cNBT) {
        super(pieceType, cNBT);
        this.location = new ResourceLocation(cNBT.func_74779_i("Template"));
        this.field_186169_c = Rotation.valueOf((String)cNBT.func_74779_i("Rot"));
        this.setup(templateManager);
    }

    public void setup(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.location);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a(this.getProcessor());
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74778_a("Template", this.location.toString());
        tagCompound.func_74778_a("Rot", this.field_186169_c.name());
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox mbb, ChunkPos chunkPos, BlockPos blockPos) {
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a(this.getProcessor());
        BlockPos blockpos1 = this.field_186178_c.func_177971_a((Vector3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3, 0, 0)));
        int i = this.getHeight(world, blockpos1);
        BlockPos blockpos2 = this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), i, this.field_186178_c.func_177952_p());
        boolean flag = super.func_230383_a_(world, structureManager, chunkGen, rand, mbb, chunkPos, this.field_186178_c);
        this.field_186178_c = blockpos2;
        return flag;
    }

    protected int getHeight(ISeedReader world, BlockPos blockpos1) {
        return world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
    }

    public StructureProcessor getProcessor() {
        return BlockIgnoreStructureProcessor.field_215206_c;
    }
}

