/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures;

import com.silverminer.shrines.structures.AbstractStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractStructureStart<C extends IFeatureConfig>
extends StructureStart<C> {
    protected static final Logger LOGGER = LogManager.getLogger(AbstractStructureStart.class);

    public AbstractStructureStart(Structure<C> structure, int chunkX, int chunkZ, MutableBoundingBox boundingbox, int p_i225874_5_, long seed) {
        super(structure, chunkX, chunkZ, boundingbox, p_i225874_5_, seed);
    }

    public void func_230366_a_(ISeedReader seedReader, StructureManager manager, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos position) {
        super.func_230366_a_(seedReader, manager, generator, random, boundingBox, position);
        if (this.func_214627_k() instanceof AbstractStructure && ((AbstractStructure)this.func_214627_k()).needsGround()) {
            for (int x = this.field_75074_b.field_78897_a - 1; this.field_75074_b.field_78893_d + 1 >= x; ++x) {
                block3: for (int z = this.field_75074_b.field_78896_c - 1; this.field_75074_b.field_78892_f + 1 >= z; ++z) {
                    for (int y = this.field_75074_b.field_78895_b - 1; y > 1; --y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        try {
                            if (!this.shouldBlockBeReplaced(seedReader, pos)) continue block3;
                            this.replaceBlock(seedReader, pos);
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private boolean shouldBlockBeReplaced(ISeedReader seedReader, BlockPos pos) {
        return seedReader.func_175623_d(pos) || seedReader.func_180495_p(pos).func_185904_a().func_76224_d() || seedReader.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    protected BlockState getTopLayerBlock(ISeedReader seedReader, BlockPos pos) {
        return seedReader.func_226691_t_(pos).func_242440_e().func_242502_e().func_204108_a();
    }

    protected BlockState getLowerLayerBlock(ISeedReader seedReader, BlockPos pos) {
        return seedReader.func_226691_t_(pos).func_242440_e().func_242502_e().func_204109_b();
    }

    private void replaceBlock(ISeedReader seedReader, BlockPos pos) {
        Block upBlock;
        BlockState state = this.getTopLayerBlock(seedReader, pos);
        Block downBlock = seedReader.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!(downBlock == Blocks.field_150346_d || downBlock == Blocks.field_196658_i || downBlock != Blocks.field_150348_b && (seedReader.func_175623_d(pos.func_177981_b(1)) || seedReader.func_175623_d(pos.func_177981_b(2)) || seedReader.func_175623_d(pos.func_177981_b(3))))) {
            state = this.getLowerLayerBlock(seedReader, pos);
        }
        if (!((upBlock = seedReader.func_180495_p(pos.func_177984_a()).func_177230_c()) != Blocks.field_196658_i && upBlock != Blocks.field_185774_da || state.func_177230_c() != Blocks.field_196658_i && state.func_177230_c() != Blocks.field_185774_da)) {
            state = Blocks.field_150346_d.func_176223_P();
        }
        seedReader.func_180501_a(pos, state, 2);
    }
}

